/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.ownreport.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSOwnReportRow;
import se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportAccountRow;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;

public class SSOwnReportMonthlyTableModel
extends SSDefaultTableModel<SSMonth> {
    private SSAccount iAccount;
    List<SSOwnReportRow> iRows;

    public SSOwnReportMonthlyTableModel(SSAccount pAccount, List<SSOwnReportRow> pRows) {
        this.iAccount = pAccount;
        this.iRows = pRows;
    }

    @Override
    public Class<?> getType() {
        return SSMonth.class;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return BigDecimal.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSMonth month = (SSMonth)this.getObject(rowIndex);
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = month.toString();
                break;
            }
            case 1: {
                value = this.iAccount == null ? new BigDecimal(0) : this.getValueForAccountAndMonth(this.iAccount, month).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return value;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.iAccount != null && columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSMonth month = (SSMonth)this.getObject(rowIndex);
        if (columnIndex == 1 && this.iAccount != null) {
            this.setValueForAccountAndMonth(this.iAccount, month, (BigDecimal)aValue);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void setAccount(SSAccount pAccount) {
        this.iAccount = pAccount;
        this.fireTableDataChanged();
    }

    public BigDecimal getValueForAccountAndMonth(SSAccount iAccount, SSMonth iMonth) {
        for (SSOwnReportRow iOwnReportRow : this.iRows) {
            for (SSOwnReportAccountRow iRow : iOwnReportRow.getAccountRows()) {
                if (iRow.getAccount() == null || !iAccount.equals(iRow.getAccount())) continue;
                return iRow.getBudget().get(iMonth);
            }
        }
        return new BigDecimal(0);
    }

    public void setValueForAccountAndMonth(SSAccount iAccount, SSMonth iMonth, BigDecimal iValue) {
        for (SSOwnReportRow iOwnReportRow : this.iRows) {
            for (SSOwnReportAccountRow iRow : iOwnReportRow.getAccountRows()) {
                if (iRow.getAccount() == null || !iAccount.equals(iRow.getAccount())) continue;
                iRow.getBudget().put(iMonth, iValue);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.ownreport.util.SSOwnReportMonthlyTableModel");
        sb.append("{iAccount=").append(this.iAccount);
        sb.append(", iRows=").append(this.iRows);
        sb.append('}');
        return sb.toString();
    }
}

