/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.periodicinvoice.util;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.data.SSPeriodicInvoice;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPendingInvoiceTableModel
extends SSTableModel<Entry> {
    public static SSTableColumn<Entry> COLUMN_NUMBER = new SSTableColumn<Entry>(SSBundle.getBundle().getString("periodicinvoicetable.column.1")){

        @Override
        public Object getValue(Entry iEntry) {
            return iEntry.iPeriodicInvoice.getNumber();
        }

        @Override
        public void setValue(Entry iEntry, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<Entry> COLUMN_DESCRIPTION = new SSTableColumn<Entry>(SSBundle.getBundle().getString("periodicinvoicetable.column.2")){

        @Override
        public Object getValue(Entry iEntry) {
            return iEntry.iPeriodicInvoice.getDescription();
        }

        @Override
        public void setValue(Entry iEntry, Object iValue) {
            iEntry.iPeriodicInvoice.setDescription((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 250;
        }
    };
    public static SSTableColumn<Entry> COLUMN_DATE = new SSTableColumn<Entry>(SSBundle.getBundle().getString("invoicetable.column.5")){

        @Override
        public Object getValue(Entry iEntry) {
            return iEntry.iInvoice.getDate();
        }

        @Override
        public void setValue(Entry iEntry, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return Date.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<Entry> COLUMN_CUSTOMER_NR = new SSTableColumn<Entry>(SSBundle.getBundle().getString("invoicetable.column.3")){

        @Override
        public Object getValue(Entry iEntry) {
            return iEntry.iInvoice.getCustomerNr();
        }

        @Override
        public void setValue(Entry iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<Entry> COLUMN_CUSTOMER_NAME = new SSTableColumn<Entry>(SSBundle.getBundle().getString("invoicetable.column.4")){

        @Override
        public Object getValue(Entry iEntry) {
            return iEntry.iInvoice.getCustomerName();
        }

        @Override
        public void setValue(Entry iInvoice, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };

    public SSPendingInvoiceTableModel(Map<SSPeriodicInvoice, List<SSInvoice>> iInvoices) {
        LinkedList<Entry> iItems = new LinkedList<Entry>();
        for (SSPeriodicInvoice iPeriodicInvoice : iInvoices.keySet()) {
            for (SSInvoice iInvoice : iInvoices.get(iPeriodicInvoice)) {
                Entry iEntry = new Entry();
                iEntry.iPeriodicInvoice = iPeriodicInvoice;
                iEntry.iInvoice = iInvoice;
                iEntry.iSelected = false;
                iItems.add(iEntry);
            }
        }
        this.setObjects(iItems);
    }

    @Override
    public Class getType() {
        return Entry.class;
    }

    public Map<SSPeriodicInvoice, List<SSInvoice>> getSelected() {
        HashMap<SSPeriodicInvoice, List<SSInvoice>> iSelected = new HashMap<SSPeriodicInvoice, List<SSInvoice>>();
        for (Entry iEntry : this.getObjects()) {
            LinkedList<SSInvoice> iInvoices = (LinkedList<SSInvoice>)iSelected.get(iEntry.iPeriodicInvoice);
            if (iInvoices == null) {
                iInvoices = new LinkedList<SSInvoice>();
                iSelected.put(iEntry.iPeriodicInvoice, iInvoices);
            }
            if (!iEntry.iSelected.booleanValue()) continue;
            iInvoices.add(iEntry.iInvoice);
        }
        return iSelected;
    }

    public void selectAll() {
        for (Entry entry : this.getObjects()) {
            entry.iSelected = true;
        }
        this.fireTableDataChanged();
    }

    public SSTableColumn<Entry> getSelectionColumn() {
        return new SSTableColumn<Entry>(SSBundle.getBundle().getString("periodicinvoicetable.column.5")){

            @Override
            public Object getValue(Entry iEntry) {
                return iEntry.iSelected;
            }

            @Override
            public void setValue(Entry iEntry, Object iValue) {
                iEntry.iSelected = (Boolean)iValue;
            }

            @Override
            public Class getColumnClass() {
                return Boolean.class;
            }

            @Override
            public int getDefaultWidth() {
                return 60;
            }
        };
    }

    public static class Entry {
        SSPeriodicInvoice iPeriodicInvoice;
        SSInvoice iInvoice;
        Boolean iSelected;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.periodicinvoice.util.SSPendingInvoiceTableModel.Entry");
            sb.append("{iInvoice=").append(this.iInvoice);
            sb.append(", iPeriodicInvoice=").append(this.iPeriodicInvoice);
            sb.append(", iSelected=").append(this.iSelected);
            sb.append('}');
            return sb.toString();
        }
    }
}

