/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.product;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.product.SSProductDialog;
import se.swedsoft.bookkeeping.gui.product.panel.SSProductSearchPanel;
import se.swedsoft.bookkeeping.gui.product.util.SSProductTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSXMLFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.excel.SSProductExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSProductImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.report.SSProductListPrinter;
import se.swedsoft.bookkeeping.print.report.SSProductRevenuePrinter;

public class SSProductFrame
extends SSDefaultTableFrame {
    private static SSProductFrame cInstance;
    private SSTable iTable;
    private SSProductTableModel iModel;
    private SSProductSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSProductFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSProductFrame getInstance() {
        return cInstance;
    }

    private SSProductFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("productframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "productframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductDialog.newDialog(SSProductFrame.this.getMainFrame(), SSProductFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "productframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProduct iSelected = (SSProduct)SSProductFrame.this.iModel.getSelectedRow(SSProductFrame.this.iTable);
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSProductFrame.this.getProduct(iSelected);
                }
                if (iSelected != null) {
                    SSProductDialog.editDialog(SSProductFrame.this.getMainFrame(), iSelected, SSProductFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSProductFrame.this.getMainFrame(), "productframe.productgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "productframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProduct iSelected = (SSProduct)SSProductFrame.this.iModel.getSelectedRow(SSProductFrame.this.iTable);
                String iNumber = iSelected.getNumber();
                if ((iSelected = SSProductFrame.this.getProduct(iSelected)) != null) {
                    SSProductDialog.copyDialog(SSProductFrame.this.getMainFrame(), iSelected, SSProductFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSProductFrame.this.getMainFrame(), "productframe.productgone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "productframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSProductFrame.this.iTable.getSelectedRows();
                List toDelete = SSProductFrame.this.iModel.getObjects(selected);
                SSProductFrame.this.deleteSelectedProducts(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_IMPORT", "productframe.importbutton");
        iButton2.add("productframe.import.excel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                if (iFilechooser.showOpenDialog(SSProductFrame.this.getMainFrame()) == 0) {
                    try {
                        SSProductImporter iImporter = new SSProductImporter(iFilechooser.getSelectedFile());
                        iImporter.doImport();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSProductFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSImportException ex) {
                        SSErrorDialog.showDialog(SSProductFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    SSProductFrame.this.iModel.fireTableDataChanged();
                }
            }
        });
        iButton2.add("productframe.import.xml", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                iFilechooser.setSelectedFile(new File("Produktlista.xml"));
                if (iFilechooser.showOpenDialog(SSProductFrame.this.getMainFrame()) == 0) {
                    SSProductImporter iImporter = new SSProductImporter(iFilechooser.getSelectedFile());
                    try {
                        iImporter.doXMLImport();
                    }
                    catch (SSImportException e1) {
                        SSErrorDialog.showDialog(SSProductFrame.this.getMainFrame(), "", e1.getLocalizedMessage());
                    }
                }
            }
        });
        iToolBar.add(iButton2);
        iButton2 = new SSMenuButton("ICON_EXPORT", "productframe.exportbutton");
        iButton2.add("productframe.export.excel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iItems;
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                List iSelected = SSProductFrame.this.iModel.getSelectedRows(SSProductFrame.this.iTable);
                if ((iSelected = SSProductFrame.this.getProducts(iSelected)) != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSProductFrame.this.getMainFrame(), 1, SSProductFrame.this.getTitle(), SSBundle.getBundle().getString("productframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = iSelected;
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getProducts();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getProducts();
                }
                iFilechooser.setSelectedFile(new File("Produktlista.xls"));
                if (iFilechooser.showSaveDialog(SSProductFrame.this.getMainFrame()) == 0) {
                    iItems = SSProductFrame.this.getProducts(iItems);
                    try {
                        SSProductExporter iExporter = new SSProductExporter(iFilechooser.getSelectedFile(), iItems);
                        iExporter.doExport();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSProductFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSProductFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        iButton2.add("customerframe.export.xml", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SSProduct> iItems;
                List<SSProduct> iSelected = SSProductFrame.this.iModel.getSelectedRows(SSProductFrame.this.iTable);
                if ((iSelected = SSProductFrame.this.getProducts(iSelected)) != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSProductFrame.this.getMainFrame(), 1, SSProductFrame.this.getTitle(), SSBundle.getBundle().getString("productframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = iSelected;
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getProducts();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getProducts();
                }
                if (!iItems.isEmpty()) {
                    SSXMLFileChooser iFilechooser = SSXMLFileChooser.getInstance();
                    iFilechooser.setSelectedFile(new File("Produktlista.xml"));
                    if (iFilechooser.showSaveDialog(SSProductFrame.this.getMainFrame()) == 0) {
                        SSProductExporter iExporter = new SSProductExporter(iFilechooser.getSelectedFile(), iItems);
                        iExporter.doXMLExport();
                    }
                }
            }
        });
        iToolBar.add(iButton2);
        iToolBar.addSeparator();
        iButton2 = new SSMenuButton("ICON_PRINT", "productframe.printbutton");
        iButton2.add("productframe.print.productrevenue", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductFrame.this.ProductRevenueReport();
            }
        });
        iButton2.add("productframe.print.productlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProductFrame.this.ProductListReport();
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        SSStock iStock = new SSStock(true);
        this.iModel = new SSProductTableModel();
        this.iModel.addColumn(SSProductTableModel.COLUMN_PARCEL);
        this.iModel.addColumn(SSProductTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSProductTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSProductTableModel.COLUMN_PRICE);
        this.iModel.addColumn(SSProductTableModel.COLUMN_UNIT);
        this.iModel.addColumn(SSProductTableModel.COLUMN_WAREHOUSE_LOCATION);
        this.iModel.addColumn(SSProductTableModel.getStockQuantityColumn(iStock));
        this.iModel.addColumn(SSProductTableModel.getStockAvaiableColumn(iStock));
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSProduct iSelected = (SSProduct)SSProductFrame.this.iModel.getSelectedRow(SSProductFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                String iNumber = iSelected.getNumber();
                if ((iSelected = SSProductFrame.this.getProduct(iSelected)) != null) {
                    SSProductDialog.editDialog(SSProductFrame.this.getMainFrame(), iSelected, SSProductFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSProductFrame.this.getMainFrame(), "productframe.productgone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSProductSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    public SSProductTableModel getModel() {
        return this.iModel;
    }

    private void deleteSelectedProducts(List<SSProduct> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "productframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSProduct iProduct : delete) {
                if (SSPostLock.isLocked("product" + iProduct.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "productframe.productopen", iProduct.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteProduct(iProduct);
            }
        }
    }

    private void ProductRevenueReport() {
        List<SSProduct> iProducts;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "productframe.printallorselected");
            switch (iOption) {
                case 0: {
                    iProducts = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iProducts = this.getProducts(iProducts);
                    break;
                }
                case 1: {
                    iProducts = SSDB.getInstance().getProducts();
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iProducts = SSDB.getInstance().getProducts();
        }
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(this.getMainFrame(), SSBundle.getBundle().getString("productrevenue.perioddialog.title"));
        if (SSDB.getInstance().getCurrentYear() != null) {
            iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
            iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(this.getMainFrame());
        if (iDialog.showDialog() != 0) {
            return;
        }
        Date iFrom = iDialog.getFrom();
        Date iTo = iDialog.getTo();
        final SSProductRevenuePrinter iPrinter = new SSProductRevenuePrinter(iProducts, iFrom, iTo);
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSProductFrame.this.getMainFrame());
            }
        });
    }

    private void ProductListReport() {
        SSProductListPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "productframe.printallorselected");
            switch (iOption) {
                case 0: {
                    List<SSProduct> iProducts = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iProducts = this.getProducts(iProducts);
                    iPrinter = new SSProductListPrinter(iProducts);
                    break;
                }
                case 1: {
                    List<SSProduct> iProducts = SSDB.getInstance().getProducts();
                    iPrinter = new SSProductListPrinter(iProducts);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            List<SSProduct> iProducts = SSDB.getInstance().getProducts();
            iPrinter = new SSProductListPrinter(iProducts);
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSProductFrame.this.getMainFrame());
            }
        });
    }

    private SSProduct getProduct(SSProduct iProduct) {
        return SSDB.getInstance().getProduct(iProduct);
    }

    private List<SSProduct> getProducts(List<SSProduct> iProducts) {
        return SSDB.getInstance().getProducts(iProducts);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iSearchPanel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.product.SSProductFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

