/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchaseorder.util;

import java.math.BigDecimal;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrderRow;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSPurchaseOrderRowTableModel
extends SSTableModel<SSPurchaseOrderRow> {
    private SSPurchaseOrderRow iEditing = new SSPurchaseOrderRow();
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_PRODUCT = new SSTableColumn<SSPurchaseOrderRow>("Produkt nr"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            SSProduct iProduct = iObject.getProduct(SSDB.getInstance().getProducts());
            return iProduct != null ? iProduct : iObject.getProductNr();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            if (iValue instanceof SSProduct) {
                iObject.setProduct((SSProduct)iValue);
            } else {
                iObject.setProductNr((String)iValue);
                SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
                if (iObject.getUnit() == null) {
                    iObject.setUnit(iCompany.getStandardUnit());
                }
            }
        }

        @Override
        public Class getColumnClass() {
            return SSProduct.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_DESCRIPTION = new SSTableColumn<SSPurchaseOrderRow>("Beskrivning"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getDescription();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            iObject.setDescription((String)iValue);
            SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
            if (iObject.getUnit() == null) {
                iObject.setUnit(iCompany.getStandardUnit());
            }
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_SUPPLIER_ARTICLE_NR = new SSTableColumn<SSPurchaseOrderRow>("Lev art nr"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getSupplierArticleNr();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            iObject.setSupplierArticleNr((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 150;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_UNITPRICE = new SSTableColumn<SSPurchaseOrderRow>("Ink\u00f6pspris"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getUnitPrice();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            iObject.setUnitPrice((BigDecimal)iValue);
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_QUANTITY = new SSTableColumn<SSPurchaseOrderRow>("Antal"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getQuantity();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            iObject.setQuantity((Integer)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_UNIT = new SSTableColumn<SSPurchaseOrderRow>("Enhet"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getUnit();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
            iObject.setUnit((SSUnit)iValue);
        }

        @Override
        public Class getColumnClass() {
            return SSUnit.class;
        }

        @Override
        public int getDefaultWidth() {
            return 60;
        }
    };
    public static SSTableColumn<SSPurchaseOrderRow> COLUMN_SUM = new SSTableColumn<SSPurchaseOrderRow>("Summa"){

        @Override
        public Object getValue(SSPurchaseOrderRow iObject) {
            return iObject.getSum();
        }

        @Override
        public void setValue(SSPurchaseOrderRow iObject, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return BigDecimal.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };

    @Override
    public Class getType() {
        return SSPurchaseOrderRow.class;
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    @Override
    public SSPurchaseOrderRow getObject(int row) {
        if (row == super.getRowCount()) {
            return this.iEditing;
        }
        return (SSPurchaseOrderRow)super.getObject(row);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
        if (this.getObject(rowIndex) == this.iEditing && aValue != null && !"".equals(aValue)) {
            this.add(this.iEditing);
            this.iEditing = new SSPurchaseOrderRow();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.purchaseorder.util.SSPurchaseOrderRowTableModel");
        sb.append("{iEditing=").append(this.iEditing);
        sb.append('}');
        return sb.toString();
    }
}

