/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.purchasesuggestion.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import se.swedsoft.bookkeeping.calc.math.SSPurchaseOrderMath;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSStock;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.purchasesuggestion.util.SSPurchaseSuggestionTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSSupplierCellEditor;

public class SSPurchaseSuggestionDialog
extends SSDialog {
    private SSPurchaseSuggestionTableModel iModel;
    private SSButtonPanel iButtonPanel;
    private JPanel iPanel;
    private SSTable iTable;
    private List<SSProduct> iProducts;

    public SSPurchaseSuggestionDialog(SSMainFrame iMainFrame) {
        super(iMainFrame, SSBundle.getBundle().getString("purchasesuggestiondialog.title"));
        this.$$$setupUI$$$();
        this.iProducts = this.getProductsForPurchaseSuggestion();
        this.iModel = new SSPurchaseSuggestionTableModel(this.iProducts);
        this.iModel.addColumn(this.iModel.getSelectionColumn(), true);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_DESCRIPTION);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_ORDERPOINT);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_STOCK_QUANTITY);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_INCOMMING);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_ORDER_VOLUME, true);
        this.iModel.addColumn(SSPurchaseSuggestionTableModel.COLUMN_SUPPLIER, true);
        this.iModel.setupTable(this.iTable);
        this.iModel.selectAll();
        this.iTable.setDefaultEditor(SSSupplier.class, new SSSupplierCellEditor());
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPurchaseSuggestionDialog.this.setModalResult(2);
                SSPurchaseSuggestionDialog.this.setVisible(false);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSPurchaseSuggestionDialog.this.iModel.getSelected() == null) {
                    new SSErrorDialog(SSMainFrame.getInstance(), "purchasesuggestiondialog.nosupplier");
                    return;
                }
                SSPurchaseSuggestionDialog.this.setModalResult(0);
                SSPurchaseSuggestionDialog.this.setVisible(false);
            }
        });
        this.iButtonPanel.getOkButton().setEnabled(!this.iProducts.isEmpty());
        this.setPanel(this.iPanel);
    }

    private List<SSProduct> getProductsForPurchaseSuggestion() {
        LinkedList<SSProduct> iProducts = new LinkedList<SSProduct>();
        SSStock iStock = new SSStock(true);
        for (SSProduct iProduct : SSDB.getInstance().getProducts()) {
            if (iProduct.isParcel() || !iProduct.isStockProduct()) continue;
            Integer iStockQuantity = iStock.getQuantity(iProduct) == null ? 0 : iStock.getQuantity(iProduct);
            Integer iOrderPoint = iProduct.getOrderpoint() == null ? 0 : iProduct.getOrderpoint();
            Integer iIncomming = SSPurchaseOrderMath.getNumberOfIncommingProducts(iProduct);
            if (iStockQuantity + iIncomming >= iOrderPoint) continue;
            iProducts.add(iProduct);
        }
        return iProducts;
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkActionListener(ActionListener l) {
        this.iButtonPanel.addOkActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.iButtonPanel.addCancelActionListener(l);
    }

    public static void showDialog(SSMainFrame iMainFrame) {
        String lockString = "purchasesuggestion" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "purchasesuggestion.iscreated");
            return;
        }
        SSPurchaseSuggestionDialog iDialog = new SSPurchaseSuggestionDialog(iMainFrame);
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible(true);
        if (iDialog.getModalResult() != 0) {
            SSPostLock.removeLock(lockString);
            return;
        }
        List<SSProduct> iProducts = iDialog.iModel.getSelected();
        LinkedList<SSProduct> iUseForPurchaseOrder = new LinkedList<SSProduct>();
        String iAddedOrders = "";
        for (SSSupplier iSupplier : SSDB.getInstance().getSuppliers()) {
            iUseForPurchaseOrder.clear();
            for (SSProduct iProduct : iProducts) {
                if (iProduct.getOrdercount() == null || !iSupplier.getNumber().equals(iProduct.getSupplierNr()) || iProduct.getOrdercount() <= 0) continue;
                iUseForPurchaseOrder.add(iProduct);
            }
            if (iUseForPurchaseOrder.isEmpty()) continue;
            if (iAddedOrders.length() != 0) {
                iAddedOrders = iAddedOrders + ", ";
            }
            SSPurchaseOrder iPurchaseOrder = new SSPurchaseOrder(iUseForPurchaseOrder, iSupplier);
            SSDB.getInstance().addPurchaseOrder(iPurchaseOrder);
            iAddedOrders = iAddedOrders + iPurchaseOrder.getNumber();
        }
        SSPostLock.removeLock(lockString);
        if (iAddedOrders.length() > 0) {
            SSInformationDialog.showDialog(SSMainFrame.getInstance(), "purchasesuggestiondialog.success", iAddedOrders);
        } else {
            SSInformationDialog.showDialog(SSMainFrame.getInstance(), "purchasesuggestiondialog.noordersadded");
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.purchasesuggestion.dialog.SSPurchaseSuggestionDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iProducts=").append(this.iProducts);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSTable sSTable;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), 4, 2, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel2.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }
}

