/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.status;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import javax.swing.JLabel;
import se.swedsoft.bookkeeping.app.Version;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSMainStatusBar {
    private JLabel iNameLabel = new JLabel();
    private JLabel iCompanyLabel = new JLabel();
    private JLabel iYearLabel = new JLabel();
    private JLabel iReadonlyLabel = new JLabel();
    private JLabel iMemLabel = new JLabel();

    public SSMainStatusBar() {
        this.iNameLabel.setText(String.format("%s %s", "Fribok", Version.APP_VERSION));
        this.setCompanyText(null);
        this.setYearText(null);
        SSDB.getInstance().addPropertyChangeListener("COMPANY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSNewCompany iCompany = (SSNewCompany)evt.getNewValue();
                SSMainStatusBar.this.setCompanyText(iCompany);
            }
        });
        SSDB.getInstance().addPropertyChangeListener("YEAR", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SSNewAccountingYear iAccountingYear = (SSNewAccountingYear)evt.getNewValue();
                SSMainStatusBar.this.setYearText(iAccountingYear);
            }
        });
    }

    private void setCompanyText(SSNewCompany iCompany) {
        if (iCompany == null) {
            this.iCompanyLabel.setText(SSBundle.getBundle().getString("mainframe.status.nocompany"));
            this.iCompanyLabel.setForeground(Color.RED);
        } else {
            this.iCompanyLabel.setText(iCompany.getName());
            this.iCompanyLabel.setForeground(Color.BLACK);
        }
    }

    private void setYearText(SSNewAccountingYear iAccountingYear) {
        if (iAccountingYear == null) {
            this.iYearLabel.setText(SSBundle.getBundle().getString("mainframe.status.noyear"));
            this.iYearLabel.setForeground(Color.RED);
        } else {
            DateFormat df = DateFormat.getDateInstance(3);
            StringBuilder year = new StringBuilder();
            year.append(df.format(iAccountingYear.getFrom()));
            year.append(' ');
            year.append(SSBundle.getBundle().getString("date.separator"));
            year.append(' ');
            year.append(df.format(iAccountingYear.getTo()));
            this.iYearLabel.setText(year.toString());
            this.iYearLabel.setForeground(Color.BLACK);
        }
    }

    public JLabel getNameLabel() {
        return this.iNameLabel;
    }

    public JLabel getCompanyLabel() {
        return this.iCompanyLabel;
    }

    public JLabel getYearLabel() {
        return this.iYearLabel;
    }

    public JLabel getReadonlyLabel() {
        return this.iReadonlyLabel;
    }

    public JLabel getMemLabel() {
        return this.iMemLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.status.SSMainStatusBar");
        sb.append("{iCompanyLabel=").append(this.iCompanyLabel);
        sb.append(", iMemLabel=").append(this.iMemLabel);
        sb.append(", iNameLabel=").append(this.iNameLabel);
        sb.append(", iReadonlyLabel=").append(this.iReadonlyLabel);
        sb.append(", iYearLabel=").append(this.iYearLabel);
        sb.append('}');
        return sb.toString();
    }
}

