/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.supplier;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.supplier.SSSupplierDialog;
import se.swedsoft.bookkeeping.gui.supplier.panel.SSSupplierSearchPanel;
import se.swedsoft.bookkeeping.gui.supplier.util.SSSupplierTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSProgressDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSExcelFileChooser;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.excel.SSSupplierExporter;
import se.swedsoft.bookkeeping.importexport.excel.SSSupplierImporter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;
import se.swedsoft.bookkeeping.print.dialog.SSPeriodSelectionDialog;
import se.swedsoft.bookkeeping.print.report.SSSupplierListPrinter;
import se.swedsoft.bookkeeping.print.report.SSSupplierRevenuePrinter;

public class SSSupplierFrame
extends SSDefaultTableFrame {
    private static SSSupplierFrame cInstance;
    private SSTable iTable;
    private SSSupplierTableModel iModel;
    private SSSupplierSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSSupplierFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
    }

    public static SSSupplierFrame getInstance() {
        return cInstance;
    }

    private SSSupplierFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("supplierframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "supplierframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierDialog.newDialog(SSSupplierFrame.this.getMainFrame(), SSSupplierFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "supplierframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplier iSelected = (SSSupplier)SSSupplierFrame.this.iModel.getSelectedRow(SSSupplierFrame.this.iTable);
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierFrame.this.getSupplier(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierDialog.editDialog(SSSupplierFrame.this.getMainFrame(), iSelected, SSSupplierFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierFrame.this.getMainFrame(), "supplierframe.suppliergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "supplierframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplier iSelected = (SSSupplier)SSSupplierFrame.this.iModel.getSelectedRow(SSSupplierFrame.this.iTable);
                String iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSSupplierFrame.this.getSupplier(iSelected);
                }
                if (iSelected != null) {
                    SSSupplierDialog.copyDialog(SSSupplierFrame.this.getMainFrame(), iSelected, SSSupplierFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierFrame.this.getMainFrame(), "supplierframe.suppliergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "supplierframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSSupplierFrame.this.iTable.getSelectedRows();
                List toDelete = SSSupplierFrame.this.iModel.getObjects(selected);
                SSSupplierFrame.this.deleteSelectedSuppliers(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_IMPORT", "supplierframe.importbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                if (iFilechooser.showOpenDialog(SSSupplierFrame.this.getMainFrame()) == 0) {
                    SSSupplierImporter iImporter = new SSSupplierImporter(iFilechooser.getSelectedFile());
                    if (!SSPostLock.applyLock("importsupplier")) {
                        new SSErrorDialog(SSSupplierFrame.this.getMainFrame(), "supplierframe.import.locked");
                        return;
                    }
                    try {
                        iImporter.Import();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSSupplierFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                        SSPostLock.removeLock("importsupplier");
                    }
                    catch (SSImportException ex) {
                        SSErrorDialog.showDialog(SSSupplierFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                        SSPostLock.removeLock("importsupplier");
                    }
                    SSSupplierFrame.this.iModel.fireTableDataChanged();
                    SSPostLock.removeLock("importsupplier");
                }
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EXPORT", "supplierframe.exportbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iItems;
                SSExcelFileChooser iFilechooser = SSExcelFileChooser.getInstance();
                List iSelected = SSSupplierFrame.this.iModel.getSelectedRows(SSSupplierFrame.this.iTable);
                if (iSelected != null) {
                    int select = SSQueryDialog.showDialog((JFrame)SSSupplierFrame.this.getMainFrame(), 1, SSSupplierFrame.this.getTitle(), SSBundle.getBundle().getString("supplierframe.import.allorselected"));
                    switch (select) {
                        case 0: {
                            iItems = SSSupplierFrame.this.getSuppliers(iSelected);
                            break;
                        }
                        case 1: {
                            iItems = SSDB.getInstance().getSuppliers();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                } else {
                    iItems = SSDB.getInstance().getSuppliers();
                }
                iFilechooser.setSelectedFile(new File("Leverant\u00f6rslista.xls"));
                if (iFilechooser.showSaveDialog(SSSupplierFrame.this.getMainFrame()) == 0) {
                    try {
                        SSSupplierExporter iExporter = new SSSupplierExporter(iFilechooser.getSelectedFile(), iItems);
                        iExporter.export();
                    }
                    catch (IOException ex) {
                        SSErrorDialog.showDialog(SSSupplierFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                    catch (SSExportException ex) {
                        SSErrorDialog.showDialog(SSSupplierFrame.this.getMainFrame(), "", ex.getLocalizedMessage());
                    }
                }
            }
        });
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_PRINT", "supplierframe.printbutton");
        iButton2.add("supplierframe.print.supplierrevenue", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierFrame.this.SupplierRevenueReport();
            }
        });
        iButton2.add("supplierframe.print.supplierlist", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierFrame.this.SupplierListReport();
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iModel = new SSSupplierTableModel();
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_NAME);
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_PHONE);
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_OUR_CUSTOMER_NR);
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_YOUR_CONTACT);
        this.iModel.addColumn(SSSupplierTableModel.COLUMN_SUPPLIERDEBT);
        this.iTable = new SSTable();
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplier iSelected = (SSSupplier)SSSupplierFrame.this.iModel.getSelectedRow(SSSupplierFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                String iNumber = iSelected.getNumber();
                iSelected = SSSupplierFrame.this.getSupplier(iSelected);
                if (iSelected != null) {
                    SSSupplierDialog.editDialog(SSSupplierFrame.this.getMainFrame(), iSelected, SSSupplierFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSSupplierFrame.this.getMainFrame(), "supplierframe.suppliergone", iNumber);
                }
            }
        });
        this.iSearchPanel = new SSSupplierSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return false;
    }

    private void deleteSelectedSuppliers(List<SSSupplier> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "supplierframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSSupplier iSupplier : delete) {
                if (SSPostLock.isLocked("supplier" + iSupplier.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "supplierframe.supplieropen", iSupplier.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteSupplier(iSupplier);
            }
        }
    }

    private void SupplierRevenueReport() {
        List<SSSupplier> iSuppliers;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "supplierframe.printallorselected");
            switch (iOption) {
                case 0: {
                    iSuppliers = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iSuppliers = this.getSuppliers(iSuppliers);
                    break;
                }
                case 1: {
                    iSuppliers = SSDB.getInstance().getSuppliers();
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            iSuppliers = SSDB.getInstance().getSuppliers();
        }
        SSPeriodSelectionDialog iDialog = new SSPeriodSelectionDialog(this.getMainFrame(), SSBundle.getBundle().getString("supplierrevenue.perioddialog.title"));
        if (SSDB.getInstance().getCurrentYear() != null) {
            iDialog.setFrom(SSDB.getInstance().getCurrentYear().getFrom());
            iDialog.setTo(SSDB.getInstance().getCurrentYear().getTo());
        } else {
            Calendar iCal = Calendar.getInstance();
            iDialog.setFrom(iCal.getTime());
            iCal.add(2, 1);
            iDialog.setTo(iCal.getTime());
        }
        iDialog.setLocationRelativeTo(this.getMainFrame());
        if (iDialog.showDialog() != 0) {
            return;
        }
        Date iFrom = iDialog.getFrom();
        Date iTo = iDialog.getTo();
        final SSSupplierRevenuePrinter iPrinter = new SSSupplierRevenuePrinter(iSuppliers, iFrom, iTo);
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSSupplierFrame.this.getMainFrame());
            }
        });
    }

    private void SupplierListReport() {
        SSSupplierListPrinter iPrinter;
        if (this.iTable.getSelectedRowCount() > 0) {
            int iOption = SSQueryDialog.showDialog(this.getMainFrame(), 1, "supplierframe.printallorselected");
            switch (iOption) {
                case 0: {
                    List<SSSupplier> iSuppliers = this.iModel.getObjects(this.iTable.getSelectedRows());
                    iSuppliers = this.getSuppliers(iSuppliers);
                    iPrinter = new SSSupplierListPrinter(iSuppliers);
                    break;
                }
                case 1: {
                    List<SSSupplier> iSuppliers = this.iModel.getObjects();
                    iSuppliers = this.getSuppliers(iSuppliers);
                    iPrinter = new SSSupplierListPrinter(iSuppliers);
                    break;
                }
                default: {
                    return;
                }
            }
        } else {
            List<SSSupplier> iSuppliers = this.iModel.getObjects();
            iSuppliers = this.getSuppliers(iSuppliers);
            iPrinter = new SSSupplierListPrinter(iSuppliers);
        }
        SSProgressDialog.runProgress(this.getMainFrame(), new Runnable(){

            @Override
            public void run() {
                iPrinter.preview(SSSupplierFrame.this.getMainFrame());
            }
        });
    }

    private SSSupplier getSupplier(SSSupplier iSupplier) {
        return SSDB.getInstance().getSupplier(iSupplier);
    }

    private List<SSSupplier> getSuppliers(List<SSSupplier> iSuppliers) {
        return SSDB.getInstance().getSuppliers(iSuppliers);
    }

    public void updateFrame() {
        this.iModel.setObjects(SSDB.getInstance().getSuppliers());
        this.iSearchPanel.ApplyFilter();
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iSearchPanel = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.supplier.SSSupplierFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

