/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.supplierinvoice;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.data.SSProduct;
import se.swedsoft.bookkeeping.data.SSPurchaseOrder;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.SSSupplierInvoiceRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.supplierinvoice.panel.SSSupplierInvoicePanel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSSupplierInvoiceDialog {
    private static ResourceBundle bundle = SSBundle.getBundle();

    private SSSupplierInvoiceDialog() {
    }

    public static void newDialog(final SSMainFrame iMainFrame, final SSTableModel<SSSupplierInvoice> pModel) {
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("supplierinvoiceframe.new.title"));
        final SSSupplierInvoicePanel iPanel = new SSSupplierInvoicePanel(iDialog);
        SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice();
        iSupplierInvoice.setNumber(null);
        iPanel.setSupplierInvoice(iSupplierInvoice, true);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSupplierInvoice = iPanel.getSupplierInvoice();
                SSDB.getInstance().addSupplierInvoice(iSupplierInvoice);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "supplierinvoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void editDialog(final SSMainFrame iMainFrame, SSSupplierInvoice iSupplierInvoice, final SSTableModel<SSSupplierInvoice> pModel) {
        final String lockString = "supplierinvoice" + iSupplierInvoice.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "supplierinvoiceframe.supplierinvoiceopen", iSupplierInvoice.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("supplierinvoiceframe.edit.title"));
        final SSSupplierInvoicePanel iPanel = new SSSupplierInvoicePanel(iDialog);
        iPanel.setSupplierInvoice(new SSSupplierInvoice(iSupplierInvoice), false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSupplierInvoice = iPanel.getSupplierInvoice();
                SSDB.getInstance().updateSupplierInvoice(iSupplierInvoice);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock(lockString);
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "supplierinvoiceframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void copyDialog(final SSMainFrame iMainFrame, SSSupplierInvoice iCopyFrom, final AbstractTableModel pModel) {
        String lockString = "supplierinvoice" + iCopyFrom.getNumber() + SSDB.getInstance().getCurrentCompany().getId();
        if (SSPostLock.isLocked(lockString)) {
            new SSErrorDialog(iMainFrame, "supplierinvoiceframe.supplierinvoiceopen", iCopyFrom.getNumber());
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("supplierinvoiceframe.copy.title"));
        final SSSupplierInvoicePanel iPanel = new SSSupplierInvoicePanel(iDialog);
        SSSupplierInvoice iNew = new SSSupplierInvoice(iCopyFrom);
        iNew.setNumber(null);
        iNew.setDate(iNew.getLastDate());
        iNew.setEntered(false);
        iNew.setBGCEntered(false);
        for (SSSupplier iSupplier : SSDB.getInstance().getSuppliers()) {
            if (!iCopyFrom.getSupplierNr().equals(iSupplier.getNumber())) continue;
            iNew.setPaymentTerm(iSupplier.getPaymentTerm());
        }
        iNew.setDueDate();
        iPanel.setSupplierInvoice(iNew, false);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSupplierInvoice = iPanel.getSupplierInvoice();
                SSDB.getInstance().addSupplierInvoice(iSupplierInvoice);
                if (pModel != null) {
                    pModel.fireTableDataChanged();
                }
                iPanel.dispose();
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "supplierinvoiceframe.saveonclose", new Object[0]) != 0) {
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }

    public static void newDialog(final SSMainFrame iMainFrame, SSSupplierInvoice iInvoice, final List<SSPurchaseOrder> iOrders, final SSTableModel iModel) {
        final String lockString = "purchaseordertosupplierinvoice" + SSDB.getInstance().getCurrentCompany().getId();
        if (!SSPostLock.applyLock(lockString)) {
            new SSErrorDialog(iMainFrame, "supplierinvoiceframe.purchaseordertosupplierinvoice");
            return;
        }
        final SSDialog iDialog = new SSDialog(iMainFrame, bundle.getString("supplierinvoiceframe.new.title"));
        final SSSupplierInvoicePanel iPanel = new SSSupplierInvoicePanel(iDialog);
        SSSupplierInvoice iSupplierInvoice = new SSSupplierInvoice(iInvoice);
        for (SSSupplierInvoiceRow iRow : iSupplierInvoice.getRows()) {
            if (iRow.getProductNr() == null) continue;
            SSProduct iProduct = iRow.getProduct(SSDB.getInstance().getProducts());
            iRow.setUnitFreight(iProduct == null ? null : iProduct.getUnitFreight());
            iRow.setProject(iProduct == null ? null : iProduct.getProject(iProduct.getProjectNr()));
            iRow.setResultUnit(iProduct == null ? null : iProduct.getResultUnit(iProduct.getResultUnitNr()));
        }
        iSupplierInvoice.setNumber(null);
        iPanel.setSupplierInvoice(iSupplierInvoice, true);
        iPanel.setOrderNumbers(iOrders);
        iDialog.add((Component)iPanel.getPanel(), "Center");
        final ActionListener iSaveAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSSupplierInvoice iSupplierInvoice = iPanel.getSupplierInvoice();
                SSDB.getInstance().addSupplierInvoice(iSupplierInvoice);
                for (SSPurchaseOrder iPurchaseOrder : iOrders) {
                    iPurchaseOrder.setInvoice(iSupplierInvoice);
                    SSDB.getInstance().updatePurchaseOrder(iPurchaseOrder);
                }
                if (iModel != null) {
                    iModel.fireTableDataChanged();
                }
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        };
        iPanel.addOkAction(iSaveAction);
        iPanel.addCancelAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iPanel.dispose();
                SSPostLock.removeLock(lockString);
                iDialog.closeDialog();
            }
        });
        iDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!iPanel.isValid()) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                if (SSQueryDialog.showDialog((JFrame)iMainFrame, SSBundle.getBundle(), "supplierinvoiceframe.saveonclose", new Object[0]) != 0) {
                    SSPostLock.removeLock(lockString);
                    return;
                }
                iSaveAction.actionPerformed(null);
            }
        });
        iDialog.setSize(800, 600);
        iDialog.setLocationRelativeTo(iMainFrame);
        iDialog.setVisible();
    }
}

