/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.supplierpayments;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.supplierpayments.util.SSSupplierPaymentTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.filechooser.SSFileChooser;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFilterTXT;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.importexport.supplierpayments.SSSupplierPaymentExporter;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPaymentConfig;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class SSSupplierPaymentDialog
extends SSDialog {
    private JPanel iPanel;
    private SSTable iTable;
    private SSSupplierPaymentTableModel iModel;
    private SSButtonPanel iButtonPanel;
    private JTextField iOurBankGiroNumber;
    private JTextField iMessage;

    public SSSupplierPaymentDialog(final SSMainFrame iMainFrame, List<SSSupplierInvoice> iSupplierInvoices) {
        super(iMainFrame, SSBundle.getBundle().getString("supplierpaymentframe.title"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.setColorReadOnly(true);
        this.iModel = new SSSupplierPaymentTableModel(iSupplierInvoices);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_SUPPLIER_NUMBER);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_SUPPLIER_NAME);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_DATE, true);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_VALUE, true);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_PAYMENT_METHOD, true);
        this.iModel.addColumn(SSSupplierPaymentTableModel.COLUMN_ACCOUNT, true);
        this.iModel.setupTable(this.iTable);
        this.iOurBankGiroNumber.setText(SSDB.getInstance().getCurrentCompany().getBankGiroNumber());
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<SupplierPayment> iSupplierPayments = SSSupplierPaymentDialog.this.iModel.getObjects();
                for (SupplierPayment iPayment : iSupplierPayments) {
                    SSSupplierInvoice pSupplierInvoice = iPayment.getSupplierInvoice();
                    if (SSDB.getInstance().getSupplierInvoice(pSupplierInvoice) != null) continue;
                    iSupplierPayments.remove(iPayment);
                    new SSErrorDialog(iMainFrame, "supplierinvoiceframe.supplierinvoicegone", pSupplierInvoice.getNumber());
                }
                SSSupplierPaymentDialog.this.iModel.setObjects(iSupplierPayments);
                if (iSupplierPayments.isEmpty()) {
                    new SSErrorDialog(iMainFrame, "supplierinvoiceframe.nosupplierpayments");
                    return;
                }
                SSFileChooser iFileChooser = new SSFileChooser(new SSFilterTXT());
                iFileChooser.setSelectedFile(new File("Leverant\u00f6rsbetalning.txt"));
                int iResponce = iFileChooser.showSaveDialog(iMainFrame);
                if (iResponce != 0) {
                    return;
                }
                for (SupplierPayment supplierPayment : iSupplierPayments) {
                    SSSupplierInvoice pSupplierInvoice = supplierPayment.getSupplierInvoice();
                    if (SSDB.getInstance().getSupplierInvoice(pSupplierInvoice) != null) continue;
                    iSupplierPayments.remove(supplierPayment);
                    new SSErrorDialog(iMainFrame, "supplierinvoiceframe.supplierinvoicegone", pSupplierInvoice.getNumber());
                }
                SSSupplierPaymentDialog.this.iModel.setObjects(iSupplierPayments);
                if (iSupplierPayments.isEmpty()) {
                    new SSErrorDialog(iMainFrame, "supplierinvoiceframe.nosupplierpayments");
                    return;
                }
                Date iDate = new Date();
                for (SupplierPayment iSupplierPayment : iSupplierPayments) {
                    if (iSupplierPayment.getDate().after(iDate)) {
                        iDate = iSupplierPayment.getDate();
                    }
                    iSupplierPayment.getSupplierInvoice().setBGCEntered();
                    SSDB.getInstance().updateSupplierInvoice(iSupplierPayment.getSupplierInvoice());
                }
                SupplierPaymentConfig.setOurBankGiroAccount(SSSupplierPaymentDialog.this.iOurBankGiroNumber.getText());
                SupplierPaymentConfig.setMessage(SSSupplierPaymentDialog.this.iMessage.getText());
                SupplierPaymentConfig.setMessageDate(iDate);
                try {
                    SSSupplierPaymentExporter.Export(iFileChooser.getSelectedFile(), iSupplierPayments);
                }
                catch (SSExportException sSExportException) {
                    SSErrorDialog.showDialog(iMainFrame, SSBundle.getBundle().getString("supplierpaymentframe.error"), sSExportException.getMessage());
                    sSExportException.printStackTrace();
                    return;
                }
                SSPostLock.removeLock("supplierpayment" + SSDB.getInstance().getCurrentCompany().getId());
                SSSupplierPaymentDialog.this.closeDialog(0);
            }
        });
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSPostLock.removeLock("supplierpayment" + SSDB.getInstance().getCurrentCompany().getId());
                SSSupplierPaymentDialog.this.closeDialog();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SSPostLock.removeLock("supplierpayment" + SSDB.getInstance().getCurrentCompany().getId());
            }
        });
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.supplierpayments.SSSupplierPaymentDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iMessage=").append(this.iMessage);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iOurBankGiroNumber=").append(this.iOurBankGiroNumber);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSTable sSTable;
        JTextField jTextField;
        JTextField jTextField2;
        SSButtonPanel sSButtonPanel;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 1, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(3, 4, new Insets(4, 4, 4, 4), 2, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.iOurBankGiroNumber = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, new Dimension(250, -1), null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("book").getString("supplierpaymentframe.ourbankgironumber"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iMessage = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("supplierpaymentframe.message"));
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

