/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.tender;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.data.SSTender;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSMail;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.order.SSOrderDialog;
import se.swedsoft.bookkeeping.gui.order.SSOrderFrame;
import se.swedsoft.bookkeeping.gui.tender.SSTenderDialog;
import se.swedsoft.bookkeeping.gui.tender.panel.SSTenderSearchPanel;
import se.swedsoft.bookkeeping.gui.tender.util.SSTenderTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSMenuButton;
import se.swedsoft.bookkeeping.gui.util.components.SSTabbedPanePanel;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInformationDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.frame.SSDefaultTableFrame;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.print.SSReportFactory;

public class SSTenderFrame
extends SSDefaultTableFrame {
    private static SSTenderFrame cInstance;
    private SSTable iTable;
    private SSTenderTableModel iModel;
    private JTabbedPane iTabbedPane;
    private SSTenderSearchPanel iSearchPanel;

    public static void showFrame(SSMainFrame pMainFrame, int pWidth, int pHeight) {
        if (cInstance == null || cInstance.isClosed()) {
            cInstance = new SSTenderFrame(pMainFrame, pWidth, pHeight);
        }
        cInstance.setVisible(true);
        cInstance.deIconize();
        cInstance.updateFrame();
    }

    public static SSTenderFrame getInstance() {
        return cInstance;
    }

    private SSTenderFrame(SSMainFrame pMainFrame, int width, int height) {
        super(pMainFrame, SSBundle.getBundle().getString("tenderframe.title"), width, height);
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar iToolBar = new JToolBar();
        SSButton iButton = new SSButton("ICON_NEWITEM", "tenderframe.newbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTenderDialog.newDialog(SSTenderFrame.this.getMainFrame(), SSTenderFrame.this.iModel);
            }
        });
        iToolBar.add(iButton);
        iButton = new SSButton("ICON_EDITITEM", "tenderframe.editbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iSelected = (SSTender)SSTenderFrame.this.iModel.getSelectedRow(SSTenderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSTenderFrame.this.getTender(iSelected);
                }
                if (iSelected != null) {
                    SSTenderDialog.editDialog(SSTenderFrame.this.getMainFrame(), iSelected, SSTenderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSTenderFrame.this.getMainFrame(), "tenderframe.tendergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_COPYITEM", "tenderframe.copybutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iSelected = (SSTender)SSTenderFrame.this.iModel.getSelectedRow(SSTenderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSTenderFrame.this.getTender(iSelected);
                }
                if (iSelected != null) {
                    SSTenderDialog.copyDialog(SSTenderFrame.this.getMainFrame(), iSelected, SSTenderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSTenderFrame.this.getMainFrame(), "tenderframe.tendergone", iNumber);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_DELETEITEM", "tenderframe.deletebutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selected = SSTenderFrame.this.iTable.getSelectedRows();
                List toDelete = SSTenderFrame.this.iModel.getObjects(selected);
                SSTenderFrame.this.deleteSelectedTender(toDelete);
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        iButton = new SSButton("ICON_INVOICE24", "tenderframe.createorderbutton", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iSelected = (SSTender)SSTenderFrame.this.iModel.getSelectedRow(SSTenderFrame.this.iTable);
                Integer iNumber = null;
                if (iSelected != null) {
                    iNumber = iSelected.getNumber();
                    iSelected = SSTenderFrame.this.getTender(iSelected);
                }
                if (iSelected == null) {
                    new SSErrorDialog(SSTenderFrame.this.getMainFrame(), "tenderframe.tendergone", iNumber);
                    return;
                }
                if (iSelected.getOrder() != null) {
                    SSInformationDialog.showDialog(SSTenderFrame.this.getMainFrame(), "tenderframe.tenderhasorder", iSelected.getNumber());
                    return;
                }
                if (SSOrderFrame.getInstance() != null) {
                    SSOrderDialog.newDialog(SSTenderFrame.this.getMainFrame(), iSelected, SSOrderFrame.getInstance().getModel());
                } else {
                    SSOrderDialog.newDialog(SSTenderFrame.this.getMainFrame(), iSelected, null);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iButton);
        iToolBar.add(iButton);
        iToolBar.addSeparator();
        SSMenuButton iButton2 = new SSMenuButton("ICON_PRINT", "tenderframe.printbutton");
        JMenuItem iMenuItem = iButton2.add("tenderframe.print.tenderreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List iSelected = SSTenderFrame.this.iModel.getSelectedRows(SSTenderFrame.this.iTable);
                if (!(iSelected = SSTenderFrame.this.getTenders(iSelected)).isEmpty()) {
                    SSReportFactory.TenderReport(SSTenderFrame.this.getMainFrame(), iSelected);
                }
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iMenuItem = iButton2.add("tenderframe.print.emailtenderreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iSelected = (SSTender)SSTenderFrame.this.iModel.getSelectedRow(SSTenderFrame.this.iTable);
                if ((iSelected = SSTenderFrame.this.getTender(iSelected)) == null) {
                    return;
                }
                if (!SSMail.isOk(iSelected.getCustomer())) {
                    return;
                }
                SSReportFactory.EmailTenderReport(SSTenderFrame.this.getMainFrame(), iSelected);
            }
        });
        this.iTable.addSelectionDependentComponent(iMenuItem);
        iButton2.addSeparator();
        iButton2.add("tenderframe.print.tenderlistreport", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSReportFactory.TenderListReport(SSTenderFrame.this.getMainFrame());
            }
        });
        iToolBar.add(iButton2);
        return iToolBar;
    }

    @Override
    public JComponent getMainContent() {
        this.iTable = new SSTable();
        this.iModel = new SSTenderTableModel();
        this.iModel.addColumn(SSTenderTableModel.COLUMN_PRINTED);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_NUMBER);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_CUSTOMER_NR);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_CUSTOMER_NAME);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_DATE);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_NET_SUM);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_CURRENCY);
        this.iModel.addColumn(SSTenderTableModel.COLUMN_ORDER);
        this.iModel.setupTable(this.iTable);
        this.iTable.addDblClickListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSTender iSelected = (SSTender)SSTenderFrame.this.iModel.getSelectedRow(SSTenderFrame.this.iTable);
                if (iSelected == null) {
                    return;
                }
                Integer iNumber = iSelected.getNumber();
                iSelected = SSTenderFrame.this.getTender(iSelected);
                if (iSelected != null) {
                    SSTenderDialog.editDialog(SSTenderFrame.this.getMainFrame(), iSelected, SSTenderFrame.this.iModel);
                } else {
                    new SSErrorDialog(SSTenderFrame.this.getMainFrame(), "tenderframe.tendergone", iNumber);
                }
            }
        });
        this.iTabbedPane = new JTabbedPane();
        this.iTabbedPane.add(SSBundle.getBundle().getString("tenderframe.filter.1"), new SSTabbedPanePanel());
        this.iTabbedPane.add(SSBundle.getBundle().getString("tenderframe.filter.2"), new SSTabbedPanePanel());
        this.iTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSTenderFrame.this.updateFrame();
            }
        });
        this.iSearchPanel = new SSTenderSearchPanel(this.iModel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout());
        iPanel.add((Component)this.iSearchPanel, "North");
        iPanel.add((Component)this.iTabbedPane, "Center");
        iPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 4, 2));
        return iPanel;
    }

    public void setFilterIndex(int index, List<SSTender> iList) {
        JPanel iPanel = (JPanel)this.iTabbedPane.getComponentAt(index);
        iPanel.removeAll();
        iPanel.add((Component)new JScrollPane(this.iTable), "Center");
        List<Object> iFiltered = Collections.emptyList();
        switch (index) {
            case 0: {
                iFiltered = iList;
                break;
            }
            case 1: {
                iFiltered = new LinkedList();
                for (SSTender iTender : iList) {
                    if (iTender.isExpired()) continue;
                    iFiltered.add(iTender);
                }
                break;
            }
        }
        this.iModel.setObjects(iFiltered);
        this.iTabbedPane.repaint();
    }

    @Override
    public JComponent getStatusBar() {
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return this.iTabbedPane;
    }

    @Override
    public boolean isCompanyFrame() {
        return true;
    }

    @Override
    public boolean isYearDataFrame() {
        return true;
    }

    public SSTenderTableModel getModel() {
        return this.iModel;
    }

    private void deleteSelectedTender(List<SSTender> delete) {
        if (delete.isEmpty()) {
            return;
        }
        SSQueryDialog iDialog = new SSQueryDialog(this.getMainFrame(), "tenderframe.delete");
        int iResponce = iDialog.getResponce();
        if (iResponce == 0) {
            for (SSTender iTender : delete) {
                if (SSPostLock.isLocked("tender" + iTender.getNumber() + SSDB.getInstance().getCurrentCompany().getId())) {
                    new SSErrorDialog(this.getMainFrame(), "tenderframe.tenderopen", iTender.getNumber());
                    continue;
                }
                SSDB.getInstance().deleteTender(iTender);
            }
        }
    }

    private SSTender getTender(SSTender iTender) {
        return SSDB.getInstance().getTender(iTender);
    }

    private List<SSTender> getTenders(List<SSTender> iTenders) {
        return SSDB.getInstance().getTenders(iTenders);
    }

    public void updateFrame() {
        this.iSearchPanel.ApplyFilter(SSDB.getInstance().getTenders());
    }

    public void actionPerformed(ActionEvent e) {
        this.iTable = null;
        this.iModel = null;
        this.iTabbedPane = null;
        cInstance = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.tender.SSTenderFrame");
        sb.append("{iModel=").append(this.iModel);
        sb.append(", iSearchPanel=").append(this.iSearchPanel);
        sb.append(", iTabbedPane=").append(this.iTabbedPane);
        sb.append(", iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }
}

