/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.tender.dialog;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.JTextComponent;
import se.swedsoft.bookkeeping.data.base.SSSale;
import se.swedsoft.bookkeeping.data.base.SSSaleRow;
import se.swedsoft.bookkeeping.data.common.SSCurrency;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSButtonPanel;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;

public class SSExchangeRateDialog
extends SSDialog {
    private JPanel iPanel;
    private SSButtonPanel iButtonPanel;
    private JLabel iLabel1;
    private JLabel iLabel2;
    private SSBigDecimalTextField iExchangeRate;

    public SSExchangeRateDialog(JDialog iDialog) {
        super(iDialog, SSBundle.getBundle().getString("tenderframe.currencycalculator"));
        this.$$$setupUI$$$();
        this.setPanel(this.iPanel);
        this.iButtonPanel.addCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExchangeRateDialog.this.closeDialog(2);
            }
        });
        this.iButtonPanel.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSExchangeRateDialog.this.closeDialog(0);
            }
        });
        this.iExchangeRate.setValue(new BigDecimal(1));
    }

    public BigDecimal getExchangeRate() {
        return this.iExchangeRate.getValue();
    }

    public void setExchangeRate(BigDecimal iExchangeRate) {
        this.iExchangeRate.setValue(iExchangeRate);
    }

    public static void showDialog(JDialog iOwner, SSSale iSale, SSCurrency iCompanyCurrency, SSCurrency iCurrentCurrency, AbstractTableModel pModel) {
        SSExchangeRateDialog iDialog = new SSExchangeRateDialog(iOwner);
        BigDecimal iExchangeRate = iCurrentCurrency.getExchangeRate();
        iDialog.iLabel2.setText(String.format("%s", iCompanyCurrency.getName()));
        iDialog.iLabel1.setText(String.format("1 %s =", iCurrentCurrency.getName()));
        if (iExchangeRate != null) {
            iDialog.iExchangeRate.setValue(iExchangeRate);
        }
        iDialog.setLocationRelativeTo(iOwner);
        if (iDialog.showDialog() != 0) {
            return;
        }
        iExchangeRate = iDialog.getExchangeRate();
        for (SSSaleRow iRow : iSale.getRows()) {
            BigDecimal iUnitPrice = iRow.getUnitprice();
            if (iUnitPrice == null) continue;
            iRow.setUnitprice(iUnitPrice.divide(iExchangeRate, 2, RoundingMode.HALF_UP));
        }
        if (pModel != null) {
            pModel.fireTableDataChanged();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.tender.dialog.SSExchangeRateDialog");
        sb.append("{iButtonPanel=").append(this.iButtonPanel);
        sb.append(", iExchangeRate=").append(this.iExchangeRate);
        sb.append(", iLabel1=").append(this.iLabel1);
        sb.append(", iLabel2=").append(this.iLabel2);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButtonPanel sSButtonPanel;
        JLabel jLabel;
        SSBigDecimalTextField sSBigDecimalTextField;
        JLabel jLabel2;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 4, new Insets(4, 4, 4, 4), 0, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("tenderframe.exchangerate"));
        jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        this.iLabel1 = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iExchangeRate = sSBigDecimalTextField = new SSBigDecimalTextField();
        ((JTextComponent)sSBigDecimalTextField).setText("0,00");
        sSBigDecimalTextField.setFractionDigits(5);
        jPanel2.add((Component)sSBigDecimalTextField, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, new Dimension(100, -1), new Dimension(100, -1), new Dimension(-1, 20)));
        this.iLabel2 = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.iButtonPanel = sSButtonPanel = new SSButtonPanel();
        jPanel.add((Component)sSButtonPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 7, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

