/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;

public class SSInputVerifier
implements DocumentListener,
ActionListener {
    private List<JComponent> iComponents = new LinkedList<JComponent>();
    private List<SSVerifierListener> iListeners = new LinkedList<SSVerifierListener>();
    private JComponent iCurrentComponent;

    public void add(JTextField iTextField) {
        iTextField.getDocument().addDocumentListener(this);
        this.iComponents.add(iTextField);
    }

    public void add(JFormattedTextField iFormattedTextField) {
        iFormattedTextField.getDocument().addDocumentListener(this);
        this.iComponents.add(iFormattedTextField);
    }

    public void add(SSTableComboBoxOld iTableComboBox) {
        iTableComboBox.addChangeListener(this);
        iTableComboBox.getDocument().addDocumentListener(this);
        this.iComponents.add(iTableComboBox);
    }

    public void add(SSTableComboBox iTableComboBox) {
        iTableComboBox.addChangeListener(this);
        iTableComboBox.getDocument().addDocumentListener(this);
        this.iComponents.add(iTableComboBox);
    }

    public void update() {
        this.notifyListeners();
    }

    public boolean isValid() {
        Iterator<JComponent> iterator = this.iComponents.iterator();
        while (iterator.hasNext()) {
            JPanel iTableComboBox;
            JFormattedTextField iFormattedTextField;
            JTextField iTextField;
            JComponent iComponent;
            this.iCurrentComponent = iComponent = iterator.next();
            if (iComponent instanceof JTextField && SSInputVerifier.isNullOrEmpty((iTextField = (JTextField)iComponent).getText())) {
                return false;
            }
            if (iComponent instanceof JFormattedTextField && (iFormattedTextField = (JFormattedTextField)iComponent).getValue() == null) {
                return false;
            }
            if (iComponent instanceof SSTableComboBoxOld && (((SSTableComboBoxOld)(iTableComboBox = (SSTableComboBoxOld)iComponent)).doAllowCustomValues() ? SSInputVerifier.isNullOrEmpty(((SSTableComboBoxOld)iTableComboBox).getText()) : ((SSTableComboBoxOld)iTableComboBox).getSelected() == null)) {
                return false;
            }
            if (!(iComponent instanceof SSTableComboBox) || ((SSTableComboBox)(iTableComboBox = (SSTableComboBox)iComponent)).getValue() != null) continue;
            return false;
        }
        this.iCurrentComponent = null;
        return true;
    }

    public JComponent getCurrentComponent() {
        return this.iCurrentComponent;
    }

    public void addListener(SSVerifierListener iListener) {
        this.iListeners.add(iListener);
        iListener.updated(this, this.isValid());
    }

    protected void notifyListeners() {
        boolean iValid = this.isValid();
        for (SSVerifierListener iListener : this.iListeners) {
            iListener.updated(this, iValid);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyListeners();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyListeners();
    }

    private static boolean isNullOrEmpty(String iText) {
        return iText == null || iText.length() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.SSInputVerifier");
        sb.append("{iComponents=").append(this.iComponents);
        sb.append(", iCurrentComponent=").append(this.iCurrentComponent);
        sb.append(", iListeners=").append(this.iListeners);
        sb.append('}');
        return sb.toString();
    }

    public static interface SSVerifierListener {
        public void updated(SSInputVerifier var1, boolean var2);
    }
}

