/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SSBigDecimalTextField
extends JFormattedTextField {
    NumberFormat iFormat = NumberFormat.getNumberInstance();
    private String iAppendText;

    public SSBigDecimalTextField() {
        AbstractAction iSetValue = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocusEvent iEvent = new FocusEvent(SSBigDecimalTextField.this, 1005, false, SSBigDecimalTextField.this);
                SSBigDecimalTextField.this.processFocusEvent(iEvent);
                SSBigDecimalTextField.this.requestFocusInWindow();
            }
        };
        AbstractAction iSetNull = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSBigDecimalTextField.this.setValue(null);
            }
        };
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SETVALUE");
        this.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "SETNULL");
        this.getActionMap().put("SETVALUE", iSetValue);
        this.getActionMap().put("SETNULL", iSetNull);
        this.iFormat = NumberFormat.getNumberInstance();
        this.iFormat.setMinimumFractionDigits(2);
        this.iFormat.setMaximumFractionDigits(2);
        NumberFormatter iFormatter = new NumberFormatter(this.iFormat);
        iFormatter.setFormat(this.iFormat);
        this.setFormatterFactory(new DefaultFormatterFactory(iFormatter));
        this.setHorizontalAlignment(11);
    }

    public SSBigDecimalTextField(Object value) {
        this();
        this.setValue(value);
    }

    public String getAppendText() {
        return this.iAppendText;
    }

    public void setAppendText(String iAppendText) {
        this.iAppendText = iAppendText;
    }

    public void setFractionDigits(int iFractionDigits) {
        this.iFormat.setMinimumFractionDigits(iFractionDigits);
        this.iFormat.setMaximumFractionDigits(iFractionDigits);
    }

    public int getFractionDigits() {
        return this.iFormat.getMaximumFractionDigits();
    }

    @Override
    public BigDecimal getValue() {
        Object iValue = super.getValue();
        if (iValue instanceof BigDecimal) {
            return (BigDecimal)iValue;
        }
        if (iValue instanceof Number) {
            return new BigDecimal(((Number)iValue).doubleValue());
        }
        return null;
    }

    @Override
    public void setText(String t) {
        if (this.iAppendText != null) {
            super.setText(t + ' ' + this.iAppendText);
        } else {
            super.setText(t);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField");
        sb.append("{iAppendText='").append(this.iAppendText).append('\'');
        sb.append(", iFormat=").append(this.iFormat);
        sb.append('}');
        return sb.toString();
    }
}

