/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public class SSButton
extends JButton {
    protected static SSBundle iBundle = SSBundle.getBundle();
    private String iIconName;

    public SSButton() {
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "ENTER_PRESSED");
        this.getActionMap().put("ENTER_PRESSED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSButton.this.fireActionPerformed(e);
            }
        });
    }

    public SSButton(String pIcon) {
        this();
        this.setIconName(pIcon);
    }

    public SSButton(String pIcon, String pBundleName) {
        this();
        if (iBundle.hasKey(pBundleName + ".title")) {
            this.setText(iBundle.getString(pBundleName + ".title"));
        }
        if (iBundle.hasKey(pBundleName + ".tooltip")) {
            this.setToolTipText(iBundle.getString(pBundleName + ".tooltip"));
        }
        this.setIconName(pIcon);
    }

    public SSButton(String pIcon, String pBundleName, ActionListener pAction) {
        this(pIcon, pBundleName);
        this.addActionListener(pAction);
    }

    public void setIconName(String pIcon) {
        this.iIconName = pIcon;
        if (this.iIconName != null && this.iIconName.length() > 0) {
            this.setIcon(SSIcon.getIcon(pIcon, SSIcon.IconState.NORMAL));
            this.setDisabledIcon(SSIcon.getIcon(pIcon, SSIcon.IconState.DISABLED));
            this.setRolloverIcon(SSIcon.getIcon(pIcon, SSIcon.IconState.HIGHLIGHTED));
        }
    }

    public String getIconName() {
        return this.iIconName;
    }

    public void setDefaultSize() {
        this.setMaximumSize(new Dimension(40, 40));
        this.setPreferredSize(new Dimension(40, 40));
    }

    public void setSelectionDependent(SSTable iTable) {
        iTable.addSelectionDependentComponent(this);
    }

    public void dispose() {
        ActionListener[] iActionListeners;
        for (ActionListener iActionListener : iActionListeners = this.getActionListeners()) {
            this.removeActionListener(iActionListener);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSButton");
        sb.append("{iIconName='").append(this.iIconName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

