/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import se.swedsoft.bookkeeping.gui.util.graphics.SSImage;

public class SSImagePanel
extends JPanel {
    private String iImageName;
    private Paint iPaint;
    private Integer iImageWidth;
    private Integer iImageHeight;

    public String getImageName() {
        return this.iImageName;
    }

    public void setImageName(String pImageName) {
        this.iImageName = pImageName;
        if (SSImage.hasImage(this.iImageName)) {
            BufferedImage iImage = SSImage.getImage(this.iImageName);
            this.iImageWidth = iImage.getWidth();
            this.iImageHeight = iImage.getHeight();
            this.iPaint = new TexturePaint(iImage, new Rectangle(0, 0, this.iImageWidth, this.iImageHeight));
            this.setPreferredSize(new Dimension(this.iImageWidth, this.iImageHeight));
        } else {
            this.iPaint = null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.iPaint != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.iPaint);
            int w = this.getWidth();
            int h = this.getHeight();
            int x = (w - this.iImageWidth) / 2;
            int y = (h - this.iImageHeight) / 2;
            g2.fillRect(x, y, w, h);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.components.SSImagePanel");
        sb.append("{iImageHeight=").append(this.iImageHeight);
        sb.append(", iImageName='").append(this.iImageName).append('\'');
        sb.append(", iImageWidth=").append(this.iImageWidth);
        sb.append(", iPaint=").append(this.iPaint);
        sb.append('}');
        return sb.toString();
    }
}

