/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.datechooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSCalendar;

public class SSDateChooser
extends JPanel
implements ActionListener,
ChangeListener {
    private JSpinner iSpinner;
    private JSpinner.DateEditor iEditor;
    private JButton iCalendarButton;
    private JDialog iPopup;
    private List<ActionListener> iChangeListeners = new LinkedList<ActionListener>();
    private SSCalendar iCalendar;
    private SpinnerDateModel iModel = new SpinnerDateModel(){

        @Override
        public void setCalendarField(int calendarField) {
            super.setCalendarField(SSDateChooser.this.iCalendarField);
        }
    };
    private String iDateFormatString = "yyyy-MM-dd";
    private int iCalendarField = 5;
    protected boolean isDateSelected;
    private JPanel iPanel;

    public SSDateChooser() {
        this.iModel.setCalendarField(2);
        this.iModel.addChangeListener(this);
        this.iSpinner = new JSpinner();
        this.iSpinner.setModel(this.iModel);
        this.iSpinner.setPreferredSize(new Dimension(-1, 20));
        this.iSpinner.setMaximumSize(new Dimension(-1, 20));
        this.iSpinner.setMinimumSize(new Dimension(-1, 20));
        this.iEditor = new JSpinner.DateEditor(this.iSpinner, this.iDateFormatString);
        this.iSpinner.setEditor(this.iEditor);
        this.iCalendar = new SSCalendar();
        this.iCalendar.addChangeListener(this);
        this.iPanel = this.iCalendar.getPanel();
        this.iPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(102, 101, 84), 1), BorderFactory.createLineBorder(new Color(247, 236, 249), 1)));
        this.iCalendarButton = new SSButton("ICON_CALENDAR16");
        this.iCalendarButton.setToolTipText(SSBundle.getBundle().getString("date.tooltip"));
        this.iCalendarButton.setPreferredSize(new Dimension(20, 20));
        this.iCalendarButton.setMaximumSize(new Dimension(20, 20));
        this.iCalendarButton.setMinimumSize(new Dimension(20, 20));
        this.iCalendarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SSDateChooser.this.iPopup == null) {
                    SSDateChooser.this.createPopup(SSDateChooser.this);
                }
                int x = SSDateChooser.this.iCalendarButton.getWidth() - ((SSDateChooser)SSDateChooser.this).iPopup.getPreferredSize().width;
                int y = SSDateChooser.this.iCalendarButton.getY() + SSDateChooser.this.iCalendarButton.getHeight();
                SSDateChooser.this.isDateSelected = false;
                SSDateChooser.this.iCalendar.setDate(SSDateChooser.this.getDate());
                SSDateChooser.this.show(SSDateChooser.this.iCalendarButton, x, y);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.iSpinner, "Center");
        this.add((Component)this.iCalendarButton, "East");
        this.setDate(new Date());
    }

    public void show(Component invoker, int x, int y) {
        if (this.iPopup == null) {
            this.createPopup(invoker);
        }
        if (invoker != null) {
            Point invokerOrigin = invoker.getLocationOnScreen();
            this.iPopup.setLocation(invokerOrigin.x + x, invokerOrigin.y + y);
        } else {
            this.iPopup.setLocation(x, y);
        }
        this.iPopup.setVisible(true);
        this.iPopup.requestFocusInWindow();
    }

    private void createPopup(Component invoker) {
        JDialog iDialog = this.getDialog(invoker);
        this.iPopup = iDialog != null ? new JDialog(iDialog) : new JDialog();
        this.iPopup.setUndecorated(true);
        this.iPopup.getRootPane().setWindowDecorationStyle(0);
        this.iPopup.setAlwaysOnTop(true);
        this.iPopup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                SSDateChooser.this.iPopup.setVisible(false);
            }
        });
        this.iPopup.add(this.iPanel);
        this.iPopup.pack();
    }

    private JDialog getDialog(Component c) {
        for (Component w = c; w != null; w = w.getParent()) {
            if (!(w instanceof JDialog)) continue;
            return (JDialog)w;
        }
        return null;
    }

    public Date getDate() {
        return this.iModel.getDate();
    }

    public void setDate(Date iDate) {
        if (iDate != null) {
            this.iModel.setValue(iDate);
        } else {
            this.iModel.setValue(new Date());
        }
    }

    public String getDateFormatString() {
        return this.iDateFormatString;
    }

    public void setDateFormatString(String iDateFormatString) {
        this.iDateFormatString = iDateFormatString;
        this.iEditor.getFormat().applyPattern(iDateFormatString);
        this.iEditor.getTextField().setValue(this.iModel.getDate());
        this.invalidate();
    }

    public void setCalendarField(int iCalendarField) {
        this.iCalendarField = iCalendarField;
    }

    public int getCalendarField() {
        return this.iCalendarField;
    }

    public void addChangeListener(ActionListener iActionListener) {
        this.iChangeListeners.add(iActionListener);
    }

    private void notifyChangeListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "date");
        for (ActionListener iActionListener : this.iChangeListeners) {
            iActionListener.actionPerformed(iEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Date iDate = this.iCalendar.getDate();
        this.iModel.setValue(iDate);
        if (e.getActionCommand().equals("day")) {
            this.isDateSelected = true;
            this.iPopup.setVisible(false);
        }
    }

    public JComponent getEditor() {
        return this.iSpinner.getEditor();
    }

    public boolean isInCurrentAccountYear() {
        Date iAccountYearTo = SSDB.getInstance().getCurrentYear().getTo();
        Date iAccountYearFrom = SSDB.getInstance().getCurrentYear().getFrom();
        Calendar iCalTo = Calendar.getInstance();
        iCalTo.setTime(iAccountYearTo);
        iCalTo.add(10, 23);
        iCalTo.add(12, 59);
        iAccountYearTo = iCalTo.getTime();
        Date iCurrent = this.iModel.getDate();
        return !iCurrent.before(iAccountYearFrom) && !iCurrent.after(iAccountYearTo);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.notifyChangeListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.iCalendarButton.setEnabled(enabled);
        this.iSpinner.setEnabled(enabled);
        this.iEditor.setEnabled(enabled);
    }

    public void dispose() {
        ChangeListener[] iChangeListeners;
        ActionListener[] iActionListeners;
        this.iSpinner.removeAll();
        this.iSpinner = null;
        this.iEditor.removeAll();
        this.iEditor = null;
        for (ActionListener iActionListener : iActionListeners = this.iCalendarButton.getActionListeners()) {
            this.iCalendarButton.removeActionListener(iActionListener);
        }
        this.iCalendarButton.removeAll();
        this.iCalendarButton = null;
        if (this.iPopup != null) {
            WindowListener[] iWindowListeners;
            for (WindowListener iWindowListener : iWindowListeners = this.iPopup.getWindowListeners()) {
                this.iPopup.removeWindowListener(iWindowListener);
            }
            this.iPopup.removeAll();
            this.iPopup.getContentPane().removeAll();
            this.iPopup.dispose();
        }
        this.iChangeListeners.removeAll(this.iChangeListeners);
        this.iChangeListeners = null;
        this.iCalendar.dispose();
        this.iCalendar = null;
        for (ChangeListener iChangeListener : iChangeListeners = this.iModel.getChangeListeners()) {
            this.iModel.removeChangeListener(iChangeListener);
        }
        this.iModel = null;
        this.iDateFormatString = null;
        this.iPanel.removeAll();
        this.iPanel = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser");
        sb.append("{iCalendar=").append(this.iCalendar);
        sb.append(", iCalendarButton=").append(this.iCalendarButton);
        sb.append(", iCalendarField=").append(this.iCalendarField);
        sb.append(", iChangeListeners=").append(this.iChangeListeners);
        sb.append(", iDateFormatString='").append(this.iDateFormatString).append('\'');
        sb.append(", iEditor=").append(this.iEditor);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iPopup=").append(this.iPopup);
        sb.append(", isDateSelected=").append(this.isDateSelected);
        sb.append(", iSpinner=").append(this.iSpinner);
        sb.append('}');
        return sb.toString();
    }
}

