/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.datechooser.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SSQuaterChooser
extends JPanel
implements ItemListener {
    private JComboBox iComboBox;
    private JPanel iPanel;
    private Date iDate;
    private List<ActionListener> iChangeListeners;

    public SSQuaterChooser() {
        this.$$$setupUI$$$();
        this.iChangeListeners = new LinkedList<ActionListener>();
        this.setLayout(new BorderLayout());
        this.add((Component)this.iPanel, "Center");
        this.updateQuaterNames();
        this.iComboBox.addItemListener(this);
        this.setDate(new Date());
    }

    private void updateQuaterNames() {
        String[] iMonths = new DateFormatSymbols().getMonths();
        this.iComboBox.removeAllItems();
        this.iComboBox.addItem("1");
        this.iComboBox.addItem("2");
        this.iComboBox.addItem("3");
        this.iComboBox.addItem("4");
    }

    public void addChangeListener(ActionListener iActionListener) {
        this.iChangeListeners.add(iActionListener);
    }

    private void notifyChangeListeners() {
        ActionEvent iEvent = new ActionEvent(this, 0, "quater");
        for (ActionListener iActionListener : this.iChangeListeners) {
            iActionListener.actionPerformed(iEvent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.notifyChangeListeners();
    }

    public Date getDate() {
        int iIndex = this.iComboBox.getSelectedIndex();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iDate);
        iCalendar.set(2, iIndex * 3);
        iCalendar.set(5, 1);
        iCalendar.set(11, 0);
        iCalendar.set(12, 0);
        iCalendar.set(13, 0);
        this.iDate = iCalendar.getTime();
        return this.iDate;
    }

    public Date getEndDate() {
        int iIndex = this.iComboBox.getSelectedIndex();
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(this.iDate);
        iCalendar.set(2, (iIndex + 1) * 3);
        iCalendar.set(5, 1);
        iCalendar.set(11, 23);
        iCalendar.set(12, 59);
        iCalendar.set(13, 59);
        iCalendar.add(5, -1);
        return iCalendar.getTime();
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
        Calendar iCalendar = Calendar.getInstance();
        iCalendar.setTime(iDate);
        int iIndex = iCalendar.get(2) % 3;
        this.iComboBox.setSelectedIndex(iIndex);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.datechooser.panel.SSQuaterChooser");
        sb.append("{iChangeListeners=").append(this.iChangeListeners);
        sb.append(", iComboBox=").append(this.iComboBox);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.iComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }
}

