/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.filechooser;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.filechooser.util.SSFileFilter;

public class SSFileChooser
extends JFileChooser {
    public static ResourceBundle bundle = SSBundle.getBundle();

    public SSFileChooser() {
        this.setAcceptAllFileFilterUsed(false);
    }

    public SSFileChooser(SSFileFilter ... iFilters) {
        this.setAcceptAllFileFilterUsed(false);
        for (SSFileFilter iFilter : iFilters) {
            this.addChoosableFileFilter(iFilter);
        }
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        int iResult = super.showSaveDialog(parent);
        if (iResult != 0) {
            return iResult;
        }
        File iFile = this.getSelectedFile();
        if (iFile.exists()) {
            String iTitle = this.getUI().getDialogTitle(this);
            String iMessage = String.format(bundle.getString("filechooser.fileexists"), iFile.getAbsolutePath());
            if (JOptionPane.showConfirmDialog(null, iMessage, iTitle, 0, 3) != 0) {
                return 1;
            }
        }
        return iResult;
    }

    public final int showDialog(Component pParent) {
        File iFile;
        int iResult = super.showDialog(pParent, null);
        if (iResult != 0) {
            return iResult;
        }
        if (this.getDialogType() == 1 && (iFile = this.getSelectedFile()).exists()) {
            String iTitle = this.getUI().getDialogTitle(this);
            String iMessage = String.format(bundle.getString("filechooser.fileexists"), iFile.getAbsolutePath());
            if (JOptionPane.showConfirmDialog(null, iMessage, iTitle, 0, 3) != 0) {
                return 1;
            }
        }
        return iResult;
    }
}

