/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.frame;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.frame.SSFrameManager;

public abstract class SSInternalFrame
extends JInternalFrame {
    private SSMainFrame iMainFrame;

    public SSInternalFrame(SSMainFrame pMainFrame, String pTitle, int pWidth, int pHeight) {
        super(pTitle, true, true, true, true);
        this.iMainFrame = pMainFrame;
        this.iMainFrame.getDesktopPane().add(this);
        this.setLayout(new BorderLayout());
        this.setSize(pWidth, pHeight);
        this.setInCenter(pMainFrame);
        SSFrameManager.getInstance().addFrame(this);
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (!aFlag) {
            SSFrameManager.getInstance().removeFrame(this);
        }
        super.setVisible(aFlag);
    }

    public void deIconize() {
        try {
            this.setIcon(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.toFront();
        this.requestFocus();
    }

    public void addCloseListener(final ActionListener iListener) {
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                iListener.actionPerformed(new ActionEvent(this, e.getID(), null));
                SSInternalFrame.this.iMainFrame = null;
            }
        });
    }

    public SSMainFrame getMainFrame() {
        return this.iMainFrame;
    }

    public abstract boolean isCompanyFrame();

    public abstract boolean isYearDataFrame();

    public void setInCenter(JFrame iFrame) {
        int x = (iFrame.getWidth() - this.getWidth()) / 2;
        int y = (iFrame.getHeight() - this.getHeight()) / 2;
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void setInCenter(JDialog iDialog) {
        int x = (iDialog.getWidth() - this.getWidth()) / 2;
        int y = (iDialog.getHeight() - this.getHeight()) / 2;
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public void setInCenter(SSMainFrame iMainFrame) {
        int x = (iMainFrame.getDesktopPane().getWidth() - this.getWidth()) / 2;
        int y = (iMainFrame.getDesktopPane().getHeight() - this.getHeight()) / 2;
        this.setBounds(x, y, this.getWidth(), this.getHeight());
    }

    public static void closeAllFrames() {
        SSFrameManager.getInstance().close();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.frame.SSInternalFrame");
        sb.append("{iMainFrame=").append(this.iMainFrame);
        sb.append('}');
        return sb.toString();
    }
}

