/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;
import se.swedsoft.bookkeeping.gui.util.menu.SSMenuUtils;

public class SSMenuLoader {
    private static String cParserClass = "org.apache.xerces.parsers.SAXParser";
    private Map<String, JMenuBar> iMenuBars = new HashMap<String, JMenuBar>();
    private Map<String, JMenu> iMenus = new HashMap<String, JMenu>();
    private Map<String, JMenuItem> iMenuItems = new HashMap<String, JMenuItem>();
    private Map<String, List<ActionListener>> iActions = new HashMap<String, List<ActionListener>>();
    private Map<String, List<JComponent>> iDependancies = new HashMap<String, List<JComponent>>();

    public void loadMenus(InputStream stream) {
        XMLReader iReader;
        this.iMenuBars.clear();
        this.iMenus.clear();
        this.iMenuItems.clear();
        try {
            iReader = XMLReaderFactory.createXMLReader(cParserClass);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return;
        }
        iReader.setContentHandler(new MenuBuilder());
        try {
            iReader.parse(new InputSource(stream));
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public JMenuBar getMenuBar(String pName) {
        return this.iMenuBars.get(pName);
    }

    public JMenu getMenu(String pName) {
        return this.iMenus.get(pName);
    }

    public void addActionListener(String pName, ActionListener pAction) {
        List<ActionListener> iListeners = this.iActions.get(pName);
        if (iListeners == null) {
            iListeners = new LinkedList<ActionListener>();
            this.iActions.put(pName, iListeners);
        }
        iListeners.add(pAction);
    }

    public void addDependancy(String pGroup, JComponent iComponent) {
        List<JComponent> iComponents = this.iDependancies.get(pGroup);
        if (iComponents == null) {
            iComponents = new LinkedList<JComponent>();
            this.iDependancies.put(pGroup, iComponents);
        }
        iComponents.add(iComponent);
    }

    public void setEnabled(String pGroup, boolean pEnabled) {
        List<JComponent> iComponents = this.iDependancies.get(pGroup);
        if (iComponents != null) {
            for (JComponent iComponent : iComponents) {
                iComponent.setEnabled(pEnabled);
            }
        }
    }

    private void notifyActionListeners(String pName, ActionEvent pAction) {
        List<ActionListener> iListeners = this.iActions.get(pName);
        if (iListeners != null) {
            for (ActionListener iListener : iListeners) {
                iListener.actionPerformed(pAction);
            }
        } else {
            System.out.println("(SSMenuLoader)No listeners for " + pName);
        }
    }

    private ActionListener createActionListener(final String pName) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSMenuLoader.this.notifyActionListeners(pName, e);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.menu.SSMenuLoader");
        sb.append("{iActions=").append(this.iActions);
        sb.append(", iDependancies=").append(this.iDependancies);
        sb.append(", iMenuBars=").append(this.iMenuBars);
        sb.append(", iMenuItems=").append(this.iMenuItems);
        sb.append(", iMenus=").append(this.iMenus);
        sb.append('}');
        return sb.toString();
    }

    private class MenuBuilder
    extends DefaultHandler {
        private JMenuBar iMenuBar = null;
        private Stack<JMenu> iMenuStack = new Stack();

        private void createMenuBar(Attributes iAttributes) {
            String iName = iAttributes.getValue("Name");
            this.iMenuBar = new JMenuBar();
            this.iMenuBar.setName(iName);
            SSMenuLoader.this.iMenuBars.put(iName, this.iMenuBar);
        }

        private JMenu createMenu(Attributes iAttributes) {
            String iName = iAttributes.getValue("Name");
            String iText = iAttributes.getValue("Text");
            String iBundle = iAttributes.getValue("Bundle");
            String iDependent = iAttributes.getValue("Dependent");
            JMenu iMenu = new JMenu();
            iMenu.setName(iName);
            if (iBundle == null) {
                iMenu.setText(iText);
            } else {
                SSMenuUtils.setupMenu(iMenu, iBundle);
            }
            if (iDependent != null) {
                SSMenuLoader.this.addDependancy(iDependent, iMenu);
            }
            this.add(iMenu);
            SSMenuLoader.this.iMenus.put(iName, iMenu);
            return iMenu;
        }

        private void createMenuItem(Attributes iAttributes) {
            String iName = iAttributes.getValue("Name");
            String iText = iAttributes.getValue("Text");
            String iAction = iAttributes.getValue("Action");
            String iBundle = iAttributes.getValue("Bundle");
            String iDependent = iAttributes.getValue("Dependent");
            JMenuItem iMenuItem = new JMenuItem();
            iMenuItem.setName(iName);
            iMenuItem.addActionListener(SSMenuLoader.this.createActionListener(iAction));
            if (iBundle == null) {
                iMenuItem.setText(iText);
            } else {
                SSMenuUtils.setupMenuItem(iMenuItem, iBundle);
            }
            if (iDependent != null) {
                SSMenuLoader.this.addDependancy(iDependent, iMenuItem);
            }
            this.add(iMenuItem);
            SSMenuLoader.this.iMenuItems.put(iName, iMenuItem);
        }

        private void createSeparator(Attributes iAttributes) {
            if (!this.iMenuStack.isEmpty()) {
                JMenu iParent = this.iMenuStack.peek();
                iParent.addSeparator();
            }
        }

        private void add(JComponent iComponent) {
            if (!this.iMenuStack.isEmpty()) {
                JMenu iParent = this.iMenuStack.peek();
                iParent.add(iComponent);
            } else if (this.iMenuBar != null) {
                this.iMenuBar.add(iComponent);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes iAttributes) throws SAXException {
            if (localName.equalsIgnoreCase("MenuBar")) {
                this.createMenuBar(iAttributes);
            }
            if (localName.equalsIgnoreCase("Menu")) {
                JMenu iMenu = this.createMenu(iAttributes);
                this.iMenuStack.push(iMenu);
            }
            if (localName.equalsIgnoreCase("MenuItem")) {
                this.createMenuItem(iAttributes);
            }
            if (localName.equalsIgnoreCase("Separator")) {
                this.createSeparator(iAttributes);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("MenuBar")) {
                this.iMenuBar = null;
            }
            if (localName.equalsIgnoreCase("Menu")) {
                this.iMenuStack.pop();
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.util.menu.SSMenuLoader.MenuBuilder");
            sb.append("{iMenuBar=").append(this.iMenuBar);
            sb.append(", iMenuStack=").append(this.iMenuStack);
            sb.append('}');
            return sb.toString();
        }
    }
}

