/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.menu;

import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import se.swedsoft.bookkeeping.gui.util.SSBundle;

public class SSMenuUtils {
    private static SSBundle iBundle = SSBundle.getBundle();

    private SSMenuUtils() {
    }

    public static JMenu createMenu(String name) {
        KeyStroke ksMnemonic;
        String title = iBundle.getString(name + ".title");
        String mnemonic = iBundle.getString(name + ".mnemonic");
        JMenu menu = new JMenu(title);
        if (iBundle.hasKey(name + ".mnemonic") && (ksMnemonic = KeyStroke.getKeyStroke(mnemonic.charAt(0))) != null) {
            menu.setMnemonic((int)ksMnemonic.getKeyChar());
        }
        return menu;
    }

    public static JMenuItem createMenuItem(String name) {
        KeyStroke ksAccellerator;
        KeyStroke ksMnemonic;
        String title = iBundle.getString(name + ".title");
        String accellerator = iBundle.getString(name + ".accellerator");
        String mnemonic = iBundle.getString(name + ".mnemonic");
        JMenuItem menuItem = new JMenuItem(title);
        if (iBundle.hasKey(name + ".mnemonic") && (ksMnemonic = KeyStroke.getKeyStroke(mnemonic.charAt(0))) != null) {
            menuItem.setMnemonic((int)ksMnemonic.getKeyChar());
        }
        if (iBundle.hasKey(name + ".accellerator") && (ksAccellerator = KeyStroke.getKeyStroke(accellerator)) != null) {
            menuItem.setAccelerator(ksAccellerator);
        }
        return menuItem;
    }

    public static JMenuItem createMenuItem(String name, ActionListener action) {
        JMenuItem menuItem = SSMenuUtils.createMenuItem(name);
        menuItem.addActionListener(action);
        return menuItem;
    }

    public static void setupMenu(JMenu pMenu, String pName) {
        KeyStroke ksMnemonic;
        String title = iBundle.getString(pName + ".title");
        String mnemonic = iBundle.getString(pName + ".mnemonic");
        pMenu.setText(title);
        if (iBundle.hasKey(pName + ".mnemonic") && (ksMnemonic = KeyStroke.getKeyStroke(mnemonic.charAt(0))) != null) {
            pMenu.setMnemonic((int)ksMnemonic.getKeyChar());
        }
    }

    public static void setupMenuItem(JMenuItem pMenuItem, String pName) {
        KeyStroke ksAccellerator;
        KeyStroke ksMnemonic;
        String title = iBundle.getString(pName + ".title");
        String accellerator = iBundle.getString(pName + ".accellerator");
        String mnemonic = iBundle.getString(pName + ".mnemonic");
        pMenuItem.setText(title);
        if (iBundle.hasKey(pName + ".mnemonic") && (ksMnemonic = KeyStroke.getKeyStroke(mnemonic.charAt(0))) != null) {
            pMenuItem.setMnemonic((int)ksMnemonic.getKeyChar());
        }
        if (iBundle.hasKey(pName + ".accellerator") && (ksAccellerator = KeyStroke.getKeyStroke(accellerator)) != null) {
            pMenuItem.setAccelerator(ksAccellerator);
        }
    }
}

