/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.util.List;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSAccountTableModel
extends SSTableModel<SSAccount> {
    public static SSTableColumn<SSAccount> COLUMN_NUMBER = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.1")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.getNumber();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setNumber((Integer)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Integer.class;
        }

        @Override
        public int getDefaultWidth() {
            return 60;
        }
    };
    public static SSTableColumn<SSAccount> COLUMN_DESCRIPTION = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.2")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.getDescription();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setDescription((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 300;
        }
    };
    public static SSTableColumn<SSAccount> COLUMN_ACTIVE = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.3")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.isActive();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setActive((Boolean)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Boolean.class;
        }

        @Override
        public int getDefaultWidth() {
            return 16;
        }
    };
    public static SSTableColumn<SSAccount> COLUMN_VATCODE = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.4")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.getVATCode();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setVATCode((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };
    public static SSTableColumn<SSAccount> COLUMN_SRUCODE = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.5")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.getSRUCode();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setSRUCode((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return Boolean.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };
    public static SSTableColumn<SSAccount> COLUMN_REPORTCODE = new SSTableColumn<SSAccount>(SSBundle.getBundle().getString("accounttable.column.6")){

        @Override
        public Object getValue(SSAccount iAccount) {
            return iAccount.getReportCode();
        }

        @Override
        public void setValue(SSAccount iAccount, Object iValue) {
            iAccount.setReportCode((String)iValue);
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 80;
        }
    };

    public SSAccountTableModel() {
        super(SSDB.getInstance().getAccounts());
    }

    public SSAccountTableModel(List<SSAccount> iAccounts) {
        super(iAccounts);
    }

    @Override
    public Class getType() {
        return SSAccount.class;
    }

    public static SSAccountTableModel getDropDownModel() {
        List<SSAccount> iAccounts;
        SSNewAccountingYear iAccountingYear = SSDB.getInstance().getCurrentYear();
        SSAccountTableModel iModel = iAccountingYear == null ? new SSAccountTableModel() : ((iAccounts = SSDB.getInstance().getCurrentYear().getActiveAccounts()) == null ? new SSAccountTableModel() : new SSAccountTableModel(iAccounts));
        iModel.addColumn(COLUMN_NUMBER);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }

    public static SSAccountTableModel getDropDownModel(List<SSAccount> iAccounts) {
        SSAccountTableModel iModel = new SSAccountTableModel(iAccounts);
        iModel.addColumn(COLUMN_NUMBER);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }
}

