/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;

public abstract class SSDefaultTableModel<T>
extends AbstractTableModel {
    private List<T> iObjects;
    private List<String> iColumns;

    public SSDefaultTableModel() {
        this.iColumns = new LinkedList<String>();
        this.iObjects = new LinkedList<T>();
    }

    public SSDefaultTableModel(List<T> pObjects) {
        this.iColumns = new LinkedList<String>();
        this.iObjects = pObjects;
    }

    public SSDefaultTableModel(T ... pObjects) {
        this.iColumns = new LinkedList<String>();
        this.iObjects = new LinkedList<T>();
        this.iObjects.addAll(Arrays.asList(pObjects));
    }

    public SSDefaultTableModel(SSDefaultTableModel<T> pModel) {
        this.iColumns = new ArrayList<String>(pModel.iColumns);
        this.iObjects = new ArrayList<T>(pModel.iObjects);
    }

    public List<String> getColumnNames() {
        return this.iColumns;
    }

    public void setObjects(List<T> pObjects) {
        this.iObjects = pObjects;
        this.fireTableDataChanged();
    }

    public void setObjects(T ... pObjects) {
        this.iObjects = new LinkedList<T>();
        this.iObjects.addAll(Arrays.asList(pObjects));
    }

    public void addColumn(String iTitle) {
        this.iColumns.add(iTitle);
    }

    public void addColumn(SSBundleString iString) {
        this.iColumns.add(iString.getString());
    }

    @Override
    public String getColumnName(int column) {
        return column < this.iColumns.size() ? this.iColumns.get(column) : super.getColumnName(column);
    }

    @Override
    public int getRowCount() {
        return this.iObjects.size();
    }

    public boolean isLastRow(int row) {
        return row + 1 == this.iObjects.size();
    }

    @Override
    public int getColumnCount() {
        return this.iColumns.size();
    }

    public List<String> getColumns() {
        return this.iColumns;
    }

    public void add(T pObject) {
        this.iObjects.add(pObject);
        this.fireTableRowsInserted(this.iObjects.size() - 1, this.iObjects.size() - 1);
    }

    public void addAll(List<T> pObjects) {
        this.iObjects.addAll(pObjects);
        this.fireTableRowsInserted(this.iObjects.size() - pObjects.size(), this.iObjects.size());
    }

    public T getObject(int row) {
        return this.iObjects.get(row);
    }

    public void delete(T pObject) {
        int index = this.iObjects.indexOf(pObject);
        if (index >= 0) {
            this.iObjects.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void delete(int index) {
        if (index >= 0 && index < this.iObjects.size()) {
            this.iObjects.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void delete(int[] indices) {
        if (indices.length > 0) {
            for (int i = indices.length - 1; i >= 0; --i) {
                this.iObjects.remove(indices[i]);
            }
            this.fireTableRowsDeleted(indices[0], indices[indices.length - 1]);
        }
    }

    public abstract Class getType();

    public List<T> getObjects() {
        return this.iObjects;
    }

    public List<T> getObjects(int[] indices) {
        List<T> objects;
        if (indices.length == 0) {
            objects = this.iObjects;
        } else {
            objects = new ArrayList<T>(indices.length);
            for (int i : indices) {
                objects.add(this.getObject(i));
            }
        }
        return objects;
    }

    protected ResourceBundle getBundle() {
        return SSBundle.getBundle();
    }

    public void deleteRow(T iObject) {
        this.iObjects.remove(iObject);
        this.fireTableDataChanged();
    }

    public T getSelectedRow(JTable iTable) {
        int selected = iTable.getSelectedRow();
        if (selected >= 0) {
            return this.getObject(selected);
        }
        return null;
    }

    public List<T> getSelectedRows(JTable iTable) {
        int[] selected = iTable.getSelectedRows();
        if (selected.length >= 0) {
            return this.getObjects(selected);
        }
        return null;
    }

    public int indexOf(T o) {
        return this.iObjects.indexOf(o);
    }

    public void addDeleteAction(final JTable iTable) {
        AbstractAction iDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = iTable.getSelectedColumn();
                int row = iTable.getSelectedRow();
                if (iTable.isEditing()) {
                    return;
                }
                Object iSelected = SSDefaultTableModel.this.getSelectedRow(iTable);
                if (iSelected != null) {
                    SSDefaultTableModel.this.deleteRow(iSelected);
                    iTable.changeSelection(row - 1, col, false, false);
                }
            }
        };
        iTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_ROW");
        iTable.getActionMap().put("DELETE_ROW", iDelete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iObjects=").append(this.iObjects);
        sb.append('}');
        return sb.toString();
    }
}

