/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.util.List;
import javax.swing.JDialog;
import se.swedsoft.bookkeeping.data.common.SSDeliveryTerm;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSNameDescriptionDialog;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSDeliveryTermTableModel
extends SSTableModel<SSDeliveryTerm> {
    public static SSTableColumn<SSDeliveryTerm> COLUMN_NAME = new SSTableColumn<SSDeliveryTerm>(SSBundle.getBundle().getString("currencytable.column.1")){

        @Override
        public Object getValue(SSDeliveryTerm iCurrency) {
            return iCurrency.getName();
        }

        @Override
        public void setValue(SSDeliveryTerm iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSDeliveryTerm> COLUMN_DESCRIPTION = new SSTableColumn<SSDeliveryTerm>(SSBundle.getBundle().getString("currencytable.column.2")){

        @Override
        public Object getValue(SSDeliveryTerm iCurrency) {
            return iCurrency.getDescription();
        }

        @Override
        public void setValue(SSDeliveryTerm iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };

    public SSDeliveryTermTableModel() {
        super(SSDB.getInstance().getDeliveryTerms());
    }

    public SSDeliveryTermTableModel(List<SSDeliveryTerm> iPaymentTerms) {
        super(iPaymentTerms);
    }

    @Override
    public Class getType() {
        return SSDeliveryTerm.class;
    }

    public SSDeliveryTermTableModel getDropdownmodel() {
        return SSDeliveryTermTableModel.getDropDownModel();
    }

    public static SSDeliveryTermTableModel getDropDownModel() {
        SSDeliveryTermTableModel iModel = new SSDeliveryTermTableModel();
        iModel.addColumn(COLUMN_NAME);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }

    public static SSEditableTableComboBox.EditingFactory<SSDeliveryTerm> getEditingFactory(final JDialog iOwner) {
        return new SSEditableTableComboBox.EditingFactory<SSDeliveryTerm>(){

            @Override
            public SSDeliveryTerm newAction() {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("deliverytermtable.title"));
                if (iDialog.showDialog() == 0) {
                    SSDeliveryTerm iDeliveryTerm = new SSDeliveryTerm();
                    iDeliveryTerm.setName(iDialog.getName());
                    iDeliveryTerm.setDescription(iDialog.getDescription());
                    SSDB.getInstance().addDeliveryTerm(iDeliveryTerm);
                    return iDeliveryTerm;
                }
                return null;
            }

            @Override
            public void editAction(SSDeliveryTerm iSelected) {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("deliverytermtable.title"));
                iDialog.setName(iSelected.getName());
                iDialog.setDescription(iSelected.getDescription());
                if (iDialog.showDialog() == 0) {
                    iSelected.setName(iDialog.getName());
                    iSelected.setDescription(iDialog.getDescription());
                    SSDB.getInstance().updateDeliveryTerm(iSelected);
                }
            }

            @Override
            public void deleteAction(SSDeliveryTerm iSelected) {
                SSDB.getInstance().deleteDeliveryTerm(iSelected);
            }
        };
    }
}

