/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.util.List;
import javax.swing.JDialog;
import se.swedsoft.bookkeeping.data.common.SSDeliveryWay;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSNameDescriptionDialog;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSDeliveryWayTableModel
extends SSTableModel<SSDeliveryWay> {
    public static SSTableColumn<SSDeliveryWay> COLUMN_NAME = new SSTableColumn<SSDeliveryWay>(SSBundle.getBundle().getString("currencytable.column.1")){

        @Override
        public Object getValue(SSDeliveryWay iCurrency) {
            return iCurrency.getName();
        }

        @Override
        public void setValue(SSDeliveryWay iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSDeliveryWay> COLUMN_DESCRIPTION = new SSTableColumn<SSDeliveryWay>(SSBundle.getBundle().getString("currencytable.column.2")){

        @Override
        public Object getValue(SSDeliveryWay iCurrency) {
            return iCurrency.getDescription();
        }

        @Override
        public void setValue(SSDeliveryWay iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };

    public SSDeliveryWayTableModel() {
        super(SSDB.getInstance().getDeliveryWays());
    }

    public SSDeliveryWayTableModel(List<SSDeliveryWay> iPaymentTerms) {
        super(iPaymentTerms);
    }

    @Override
    public Class getType() {
        return SSDeliveryWay.class;
    }

    public SSDeliveryWayTableModel getDropdownmodel() {
        return SSDeliveryWayTableModel.getDropDownModel();
    }

    public static SSDeliveryWayTableModel getDropDownModel() {
        SSDeliveryWayTableModel iModel = new SSDeliveryWayTableModel();
        iModel.addColumn(COLUMN_NAME);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }

    public static SSEditableTableComboBox.EditingFactory<SSDeliveryWay> getEditingFactory(final JDialog iOwner) {
        return new SSEditableTableComboBox.EditingFactory<SSDeliveryWay>(){

            @Override
            public SSDeliveryWay newAction() {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("deliverywaytable.title"));
                if (iDialog.showDialog() == 0) {
                    SSDeliveryWay iDeliveryWay = new SSDeliveryWay();
                    iDeliveryWay.setName(iDialog.getName());
                    iDeliveryWay.setDescription(iDialog.getDescription());
                    SSDB.getInstance().addDeliveryWay(iDeliveryWay);
                    return iDeliveryWay;
                }
                return null;
            }

            @Override
            public void editAction(SSDeliveryWay iSelected) {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("deliverywaytable.title"));
                iDialog.setName(iSelected.getName());
                iDialog.setDescription(iSelected.getDescription());
                if (iDialog.showDialog() == 0) {
                    iSelected.setName(iDialog.getName());
                    iSelected.setDescription(iDialog.getDescription());
                    SSDB.getInstance().updateDeliveryWay(iSelected);
                }
            }

            @Override
            public void deleteAction(SSDeliveryWay iSelected) {
                SSDB.getInstance().deleteDeliveryWay(iSelected);
            }
        };
    }
}

