/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.model;

import java.util.List;
import javax.swing.JDialog;
import se.swedsoft.bookkeeping.data.common.SSUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSEditableTableComboBox;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSNameDescriptionDialog;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel;

public class SSUnitTableModel
extends SSTableModel<SSUnit> {
    public static SSTableColumn<SSUnit> COLUMN_NAME = new SSTableColumn<SSUnit>(SSBundle.getBundle().getString("currencytable.column.1")){

        @Override
        public Object getValue(SSUnit iCurrency) {
            return iCurrency.getName();
        }

        @Override
        public void setValue(SSUnit iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }
    };
    public static SSTableColumn<SSUnit> COLUMN_DESCRIPTION = new SSTableColumn<SSUnit>(SSBundle.getBundle().getString("currencytable.column.2")){

        @Override
        public Object getValue(SSUnit iCurrency) {
            return iCurrency.getDescription();
        }

        @Override
        public void setValue(SSUnit iCurrency, Object iValue) {
        }

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public int getDefaultWidth() {
            return 200;
        }
    };

    public SSUnitTableModel() {
        super(SSDB.getInstance().getUnits());
    }

    public SSUnitTableModel(List<SSUnit> iPaymentTerms) {
        super(iPaymentTerms);
    }

    @Override
    public Class getType() {
        return SSUnit.class;
    }

    public SSUnitTableModel getDropdownmodel() {
        return SSUnitTableModel.getDropDownModel();
    }

    public static SSUnitTableModel getDropDownModel() {
        SSUnitTableModel iModel = new SSUnitTableModel();
        iModel.addColumn(COLUMN_NAME);
        iModel.addColumn(COLUMN_DESCRIPTION);
        return iModel;
    }

    public static SSEditableTableComboBox.EditingFactory<SSUnit> getEditingFactory(final JDialog iOwner) {
        return new SSEditableTableComboBox.EditingFactory<SSUnit>(){

            @Override
            public SSUnit newAction() {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("unittable.title"));
                if (iDialog.showDialog() == 0) {
                    SSUnit iUnit = new SSUnit();
                    iUnit.setName(iDialog.getName());
                    iUnit.setDescription(iDialog.getDescription());
                    SSDB.getInstance().addUnit(iUnit);
                    return iUnit;
                }
                return null;
            }

            @Override
            public void editAction(SSUnit iSelected) {
                SSNameDescriptionDialog iDialog = new SSNameDescriptionDialog(iOwner, SSBundle.getBundle().getString("unittable.title"));
                iDialog.setName(iSelected.getName());
                iDialog.setDescription(iSelected.getDescription());
                if (iDialog.showDialog() == 0) {
                    iSelected.setName(iDialog.getName());
                    iSelected.setDescription(iDialog.getDescription());
                    SSDB.getInstance().updateUnit(iSelected);
                }
            }

            @Override
            public void deleteAction(SSUnit iSelected) {
                SSDB.getInstance().deleteUnit(iSelected);
            }
        };
    }
}

