/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSorter;

public class SSTable
extends JTable {
    private List<ActionListener> iDblClickListeners;
    private List<JComponent> iSelectionDependentComponents;
    private SSCustomPainter iCustomPainter;
    private boolean iColumnSortingEnabled;
    private boolean iColorReadOnly;
    final Color GRID_COLOR = new Color(80, 80, 80);
    final Color CELL_READONLY = new Color(245, 245, 245);
    final Color CELL_EDITABLE = new Color(255, 255, 255);
    final Color CELL_READONLY_SELECTED = new Color(249, 224, 137);
    final Color CELL_EDITABLE_SELECTED = new Color(251, 232, 175);

    public SSTable() {
        this.iDblClickListeners = new LinkedList<ActionListener>();
        this.iSelectionDependentComponents = new LinkedList<JComponent>();
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setRowHeight(18);
        this.setGridColor(new Color(192, 192, 192));
        this.getTableHeader().setReorderingAllowed(false);
        this.iColumnSortingEnabled = true;
        this.iColorReadOnly = false;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SSTable.this.notifyDblClickListeners();
                }
            }
        });
        this.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SSTable.this.updateSelectionDependentComponents();
            }
        });
    }

    public SSTable(TableModel dm) {
        this();
        this.setModel(dm);
    }

    @Override
    public void setModel(TableModel dataModel) {
        if (this.iColumnSortingEnabled) {
            SSTableSorter sorter = new SSTableSorter(dataModel);
            super.setModel(sorter);
            sorter.setTableHeader(this.getTableHeader());
        } else {
            super.setModel(dataModel);
        }
    }

    @Override
    public int getSelectedRow() {
        if (this.iColumnSortingEnabled) {
            int selectedRow = super.getSelectedRow();
            return selectedRow >= 0 ? ((SSTableSorter)this.getModel()).modelIndex(selectedRow) : selectedRow;
        }
        return super.getSelectedRow();
    }

    @Override
    public int[] getSelectedRows() {
        if (this.iColumnSortingEnabled) {
            int[] viewSelected = super.getSelectedRows();
            int[] modelSelected = new int[viewSelected.length];
            SSTableSorter sorter = (SSTableSorter)this.getModel();
            for (int i = 0; i < viewSelected.length; ++i) {
                modelSelected[i] = sorter.modelIndex(viewSelected[i]);
            }
            Arrays.sort(modelSelected);
            return modelSelected;
        }
        return super.getSelectedRows();
    }

    public void setSingleSelect() {
        this.getSelectionModel().setSelectionMode(0);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
        Component c = super.prepareRenderer(renderer, row, col);
        boolean isCellEditable = this.isCellEditable(row, col);
        boolean isCellSelected = this.isCellSelected(row, col);
        if (this.iColorReadOnly) {
            if (isCellEditable) {
                if (isCellSelected) {
                    c.setBackground(this.CELL_EDITABLE_SELECTED);
                } else {
                    c.setBackground(this.CELL_EDITABLE);
                }
            } else if (isCellSelected) {
                c.setBackground(this.CELL_READONLY_SELECTED);
            } else {
                c.setBackground(this.CELL_READONLY);
            }
        }
        if (this.iCustomPainter != null) {
            this.iCustomPainter.update(this, c, row, col, isCellSelected, isCellEditable);
        }
        return c;
    }

    public void addDblClickListener(ActionListener pListener) {
        this.iDblClickListeners.add(pListener);
    }

    private void notifyDblClickListeners() {
        for (ActionListener iListener : this.iDblClickListeners) {
            iListener.actionPerformed(null);
        }
    }

    public void addSelectionListener(ListSelectionListener pListener) {
        this.getSelectionModel().addListSelectionListener(pListener);
    }

    public boolean isColumnSortingEnabled() {
        return this.iColumnSortingEnabled;
    }

    public void setColumnSortingEnabled(boolean iColumnSortingEnabled) {
        this.iColumnSortingEnabled = iColumnSortingEnabled;
        if (this.getModel() instanceof SSTableSorter) {
            SSTableSorter iModel = (SSTableSorter)this.getModel();
            super.setModel(iModel.getTableModel());
        }
    }

    public boolean isColorReadOnly() {
        return this.iColorReadOnly;
    }

    public void setColorReadOnly(boolean iColorReadOnly) {
        this.iColorReadOnly = iColorReadOnly;
    }

    public SSCustomPainter getCustomPainter() {
        return this.iCustomPainter;
    }

    public void setCustomPainter(SSCustomPainter iCustomPainter) {
        this.iCustomPainter = iCustomPainter;
    }

    public void addSelectionDependentComponent(JComponent iComponent) {
        this.iSelectionDependentComponents.add(iComponent);
        iComponent.setEnabled(this.getSelectedRowCount() > 0);
    }

    private void updateSelectionDependentComponents() {
        boolean iEnabled = this.getSelectedRowCount() > 0;
        for (JComponent iComponent : this.iSelectionDependentComponents) {
            iComponent.setEnabled(iEnabled);
        }
    }

    public void dispose() {
        ListSelectionListener[] iSelectionListeners;
        MouseListener[] iMouseListeners;
        for (MouseListener iMouseListener : iMouseListeners = this.getMouseListeners()) {
            this.removeMouseListener(iMouseListener);
        }
        DefaultListSelectionModel iSelectionModel = (DefaultListSelectionModel)this.getSelectionModel();
        for (ListSelectionListener iSelectionListener : iSelectionListeners = iSelectionModel.getListSelectionListeners()) {
            this.getSelectionModel().removeListSelectionListener(iSelectionListener);
        }
        if (this.iDblClickListeners != null) {
            this.iDblClickListeners.removeAll(this.iDblClickListeners);
        }
        this.iDblClickListeners = null;
        if (this.iSelectionDependentComponents != null) {
            this.iSelectionDependentComponents.removeAll(this.iSelectionDependentComponents);
        }
        this.iSelectionDependentComponents = null;
        this.iCustomPainter = null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.SSTable");
        sb.append("{CELL_EDITABLE=").append(this.CELL_EDITABLE);
        sb.append(", CELL_EDITABLE_SELECTED=").append(this.CELL_EDITABLE_SELECTED);
        sb.append(", CELL_READONLY=").append(this.CELL_READONLY);
        sb.append(", CELL_READONLY_SELECTED=").append(this.CELL_READONLY_SELECTED);
        sb.append(", GRID_COLOR=").append(this.GRID_COLOR);
        sb.append(", iColorReadOnly=").append(this.iColorReadOnly);
        sb.append(", iColumnSortingEnabled=").append(this.iColumnSortingEnabled);
        sb.append(", iCustomPainter=").append(this.iCustomPainter);
        sb.append(", iDblClickListeners=").append(this.iDblClickListeners);
        sb.append(", iSelectionDependentComponents=").append(this.iSelectionDependentComponents);
        sb.append('}');
        return sb.toString();
    }

    public static interface SSCustomPainter {
        public void update(JTable var1, Component var2, int var3, int var4, boolean var5, boolean var6);
    }
}

