/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;

public abstract class SSTraversalAction {
    private SSTable iTable;

    public SSTraversalAction(SSTable iTable) {
        this.iTable = iTable;
        TraversalAction iTraversal = new TraversalAction();
        iTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER_TRAVERSAL");
        iTable.getActionMap().put("ENTER_TRAVERSAL", iTraversal);
    }

    protected abstract Point doTraversal(Point var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction");
        sb.append("{iTable=").append(this.iTable);
        sb.append('}');
        return sb.toString();
    }

    private class TraversalAction
    extends AbstractAction {
        private TraversalAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Point iTraversalPoint;
            int col = SSTraversalAction.this.iTable.getSelectedColumn();
            int row = SSTraversalAction.this.iTable.getSelectedRow();
            if (SSTraversalAction.this.iTable.isEditing()) {
                col = SSTraversalAction.this.iTable.getEditingColumn();
                row = SSTraversalAction.this.iTable.getEditingRow();
                if (!SSTraversalAction.this.iTable.getCellEditor(row, col).stopCellEditing()) {
                    return;
                }
            }
            if ((iTraversalPoint = SSTraversalAction.this.doTraversal(new Point(col, row))) != null) {
                SSTraversalAction.this.iTable.changeSelection(iTraversalPoint.y, iTraversalPoint.x, false, false);
            }
        }
    }
}

