/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.editors;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.common.SSTaxCode;
import se.swedsoft.bookkeeping.data.system.SSDB;

public class SSTaxCodeCellRenderer
extends DefaultTableCellRenderer {
    private Map<SSTaxCode, BigDecimal> iValues = new HashMap<SSTaxCode, BigDecimal>();

    public SSTaxCodeCellRenderer() {
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany != null) {
            this.setValue(SSTaxCode.TAXRATE_0, new BigDecimal(0));
            this.setValue(SSTaxCode.TAXRATE_1, iCompany.getTaxRate1());
            this.setValue(SSTaxCode.TAXRATE_2, iCompany.getTaxRate2());
            this.setValue(SSTaxCode.TAXRATE_3, iCompany.getTaxRate3());
        }
        this.setHorizontalAlignment(4);
    }

    @Override
    public void setValue(Object value) {
        DecimalFormat iFormat = new DecimalFormat("0");
        if (value instanceof SSTaxCode) {
            SSTaxCode iTaxCode = (SSTaxCode)value;
            BigDecimal iValue = this.iValues.get(iTaxCode);
            if (iValue != null) {
                this.setText(iFormat.format(iValue) + '%');
            } else {
                this.setText("");
            }
        } else {
            this.setText("");
        }
    }

    public void setValue(SSTaxCode iTaxCode, BigDecimal iValue) {
        this.iValues.put(iTaxCode, iValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.editors.SSTaxCodeCellRenderer");
        sb.append("{iValues=").append(this.iValues);
        sb.append('}');
        return sb.toString();
    }
}

