/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.util.table.model;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSTableEditor;
import se.swedsoft.bookkeeping.gui.util.table.model.SSTableColumn;

public abstract class SSTableModel<T>
extends AbstractTableModel {
    private List<T> iObjects;
    private List<SSTableColumn<T>> iColumns = new LinkedList<SSTableColumn<T>>();
    private Map<SSTableColumn<T>, Boolean> iEditable;

    public SSTableModel() {
        this.iObjects = new LinkedList<T>();
        this.iEditable = new HashMap<SSTableColumn<T>, Boolean>();
    }

    public SSTableModel(List<T> pObjects) {
        this();
        this.iObjects = pObjects;
    }

    public SSTableModel(T ... pObjects) {
        this();
        this.iObjects.addAll(Arrays.asList(pObjects));
    }

    public SSTableModel<T> getDropdownmodel() {
        return null;
    }

    public void setObjects(List<T> pObjects) {
        this.iObjects = pObjects;
        this.fireTableDataChanged();
    }

    public void setObjects(T ... pObjects) {
        this.iObjects = new LinkedList<T>();
        this.iObjects.addAll(Arrays.asList(pObjects));
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.iColumns.size();
    }

    public void addColumn(SSTableColumn<T> iColumn) {
        this.addColumn(iColumn, false);
    }

    public void addColumn(SSTableColumn<T> iColumn, boolean iEditable) {
        this.iColumns.add(iColumn);
        this.iEditable.put(iColumn, iEditable);
        this.fireTableDataChanged();
    }

    public void removeColumn(SSTableColumn<T> iColumn) {
        this.iColumns.remove(iColumn);
        this.iEditable.remove(iColumn);
        this.fireTableDataChanged();
    }

    public List<SSTableColumn<T>> getColumns() {
        return this.iColumns;
    }

    @Override
    public String getColumnName(int column) {
        if (column >= 0 && column < this.iColumns.size()) {
            SSTableColumn<T> iColumn = this.iColumns.get(column);
            return iColumn.getName();
        }
        return super.getColumnName(column);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSTableColumn<T> iColumn = this.iColumns.get(columnIndex);
        iColumn.setModel(this);
        T iObject = this.getObject(rowIndex);
        return iColumn.getValue(iObject);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSTableColumn<T> iColumn = this.iColumns.get(columnIndex);
        T iObject = this.getObject(rowIndex);
        iColumn.setModel(this);
        iColumn.setValue(iObject, aValue);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        SSTableColumn<T> iColumn = this.iColumns.get(columnIndex);
        iColumn.setModel(this);
        return this.iEditable.get(iColumn) != false && iColumn.isEditable(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.iObjects.size();
    }

    public void add(T pObject) {
        this.iObjects.add(pObject);
        this.fireTableRowsInserted(this.iObjects.size() - 1, this.iObjects.size() - 1);
    }

    public void addAll(List<T> pObjects) {
        this.iObjects.addAll(pObjects);
        this.fireTableRowsInserted(this.iObjects.size() - pObjects.size(), this.iObjects.size());
    }

    public T getObject(int row) {
        return this.iObjects.get(row);
    }

    public void delete(T pObject) {
        int index = this.iObjects.indexOf(pObject);
        if (index >= 0) {
            this.iObjects.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void delete(List<T> iObjects) {
        this.iObjects.removeAll(iObjects);
        this.fireTableDataChanged();
    }

    public void delete(int index) {
        if (index >= 0 && index < this.iObjects.size()) {
            this.iObjects.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public void delete(int[] indices) {
        if (indices.length > 0) {
            for (int i = indices.length - 1; i >= 0; --i) {
                this.iObjects.remove(indices[i]);
            }
            this.fireTableRowsDeleted(indices[0], indices[indices.length - 1]);
        }
    }

    public abstract Class getType();

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        SSTableColumn<T> iColumn = this.iColumns.get(columnIndex);
        return iColumn.getColumnClass();
    }

    public List<T> getObjects() {
        return this.iObjects;
    }

    public List<T> getObjects(int[] iIndices) {
        List<T> iFiltered;
        if (iIndices.length == 0) {
            iFiltered = this.iObjects;
        } else {
            iFiltered = new ArrayList<T>(iIndices.length);
            for (int i : iIndices) {
                iFiltered.add(this.getObject(i));
            }
        }
        return iFiltered;
    }

    public void deleteRow(T iObject) {
        this.iObjects.remove(iObject);
        this.fireTableDataChanged();
    }

    public int indexOf(T iObject) {
        return this.iObjects.indexOf(iObject);
    }

    public T getSelectedRow(JTable iTable) {
        int selected = iTable.getSelectedRow();
        if (selected >= 0) {
            return this.getObject(selected);
        }
        return null;
    }

    public List<T> getSelectedRows(JTable iTable) {
        int[] selected = iTable.getSelectedRows();
        if (selected.length > 0) {
            return this.getObjects(selected);
        }
        return null;
    }

    public void setupTable(SSTable iTable) {
        iTable.setModel(this);
        iTable.setAutoResizeMode(0);
        iTable.tableChanged(null);
        SSTableEditor.setDefaultEditors(iTable);
        int iIndex = 0;
        for (SSTableColumn<T> iColumn : this.iColumns) {
            int iWidth = iColumn.getDefaultWidth();
            TableCellEditor iEditor = iColumn.getCellEditor();
            TableCellRenderer iRenderer = iColumn.getCellRenderer();
            iTable.getColumnModel().getColumn(iIndex).setPreferredWidth(iWidth);
            iTable.getColumnModel().getColumn(iIndex).setCellEditor(iEditor);
            iTable.getColumnModel().getColumn(iIndex).setCellRenderer(iRenderer);
            ++iIndex;
        }
    }

    public void addDeleteAction(final JTable iTable) {
        AbstractAction iDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int col = iTable.getSelectedColumn();
                int row = iTable.getSelectedRow();
                if (iTable.isEditing()) {
                    return;
                }
                Object iSelected = SSTableModel.this.getSelectedRow(iTable);
                if (iSelected != null) {
                    SSTableModel.this.deleteRow(iSelected);
                    iTable.changeSelection(row - 1, col, false, false);
                }
            }
        };
        iTable.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "DELETE_ROW");
        iTable.getActionMap().put("DELETE_ROW", iDelete);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.util.table.model.SSTableModel");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iEditable=").append(this.iEditable);
        sb.append(", iObjects=").append(this.iObjects);
        sb.append('}');
        return sb.toString();
    }
}

