/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.panel;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSAutoDist;
import se.swedsoft.bookkeeping.data.SSAutoDistRow;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.SSVoucherTemplate;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.util.SSConfig;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.SSSelectionListener;
import se.swedsoft.bookkeeping.gui.util.components.SSBigDecimalTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSButton;
import se.swedsoft.bookkeeping.gui.util.components.SSCurrencyTextField;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBox;
import se.swedsoft.bookkeeping.gui.util.datechooser.SSDateChooser;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSDialog;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSQueryDialog;
import se.swedsoft.bookkeeping.gui.util.graphics.SSIcon;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSDeleteAction;
import se.swedsoft.bookkeeping.gui.util.table.actions.SSTraversalAction;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModel;
import se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherVerifier;
import se.swedsoft.bookkeeping.gui.vouchertemplate.util.SSVoucherTemplateTableModel;

public class SSVoucherPanel
implements TableModelListener,
ListSelectionListener {
    private JPanel iPanel;
    protected SSTable iTable;
    protected JFormattedTextField iNumber;
    protected SSTableComboBox<SSVoucherTemplate> iDescription;
    protected JCheckBox iStoreAsTemplate;
    protected SSDateChooser iDate;
    protected JButton iMarkRowButton;
    protected JButton iDeleteRowButton;
    protected JFormattedTextField iDebetSum;
    protected JFormattedTextField iCreditSum;
    protected JFormattedTextField iDifference;
    protected JLabel iErrorLabel;
    protected SSButton iOkButton;
    protected SSButton iCancelButton;
    protected SSVoucher iVoucher = null;
    protected SSVoucherRowTableModel iModel;
    protected SSVoucherVerifier iVerifier;
    private JCheckBox iReopenDialog;
    public static boolean iAccountChanged;
    public static boolean iDebetChanged;
    public static boolean iCreditChanged;
    private SSBigDecimalTextField iSaldo;
    private JTextField textField1;
    private SSBigDecimalTextField SSBigDecimalTextField1;
    private SSButton iAddAccountButton;

    public SSVoucherPanel(SSDialog iDialog) {
        this.$$$setupUI$$$();
        this.iModel = new SSVoucherRowTableModel();
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_ACCOUNT, true);
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_DESCRIPTION, true);
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_DEBET, true);
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_CREDIT, true);
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_PROJECT, true);
        this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_RESULTUNIT, true);
        this.iTable.setColorReadOnly(true);
        this.iTable.setSingleSelect();
        this.iTable.setColumnSortingEnabled(false);
        this.iTable.addSelectionListener(this);
        this.iTable.setFocusable(true);
        this.iModel.setupTable(this.iTable, true);
        this.iModel.addTableModelListener(this);
        this.iMarkRowButton.setIcon(SSIcon.getIcon("ICON_MARKVOUCHERROW", SSIcon.IconState.NORMAL));
        this.iMarkRowButton.setDisabledIcon(SSIcon.getIcon("ICON_MARKVOUCHERROW", SSIcon.IconState.DISABLED));
        this.iMarkRowButton.setRolloverIcon(SSIcon.getIcon("ICON_MARKVOUCHERROW", SSIcon.IconState.HIGHLIGHTED));
        this.iDeleteRowButton.setIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.NORMAL));
        this.iDeleteRowButton.setDisabledIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.DISABLED));
        this.iDeleteRowButton.setRolloverIcon(SSIcon.getIcon("ICON_DELETEVOUCHERROW", SSIcon.IconState.HIGHLIGHTED));
        this.iDescription.setModel(SSVoucherTemplateTableModel.getDropDownModel());
        this.iDescription.setSearchColumns(0);
        this.iDescription.setAllowCustomValues(true);
        this.iDescription.addSelectionListener(new SSSelectionListener<SSVoucherTemplate>(){

            @Override
            public void selected(SSVoucherTemplate template) {
                if (template != null) {
                    template.addToVoucher(SSVoucherPanel.this.iVoucher);
                    SSVoucherPanel.this.iModel.fireTableDataChanged();
                    SSVoucherPanel.this.iStoreAsTemplate.setEnabled(false);
                    SSVoucherPanel.this.iStoreAsTemplate.setSelected(false);
                }
            }
        });
        this.iDescription.getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SSVoucherPanel.this.iDescription.cancelCellEditing();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSVoucherPanel.this.iTable.requestFocusInWindow();
                            SSVoucherPanel.this.iTable.changeSelection(0, 0, false, false);
                        }
                    });
                }
            }
        });
        new SSTraversalAction(this.iTable){

            @Override
            protected Point doTraversal(Point iPosition) {
                if (iPosition.x == 0) {
                    iPosition.x += 2;
                } else if (iPosition.x < 3) {
                    ++iPosition.x;
                } else if (iPosition.x == 3) {
                    SSVoucherRow iVoucherRow = (SSVoucherRow)SSVoucherPanel.this.iModel.getObject(iPosition.y);
                    ++iPosition.y;
                    iPosition.x = 0;
                    if (iPosition.y == SSVoucherPanel.this.iModel.getRowCount()) {
                        SSVoucherPanel.this.iOkButton.requestFocus();
                        return null;
                    }
                    SSVoucherPanel.this.setDifferenceToZero(iVoucherRow);
                } else {
                    ++iPosition.y;
                    iPosition.x = 0;
                }
                return iPosition;
            }
        };
        new SSDeleteAction(this.iTable){

            @Override
            protected Point doDelete(Point iPosition) {
                SSVoucherRow iSelected = (SSVoucherRow)SSVoucherPanel.this.iModel.getSelectedRow(SSVoucherPanel.this.iTable);
                if (iSelected != null && SSVoucherPanel.this.iModel.allowDeletion(iSelected)) {
                    if (SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "voucherframe.deleterow", iSelected.toString()) != 0) {
                        return null;
                    }
                    SSVoucherPanel.this.iModel.deleteRow(iSelected);
                }
                return iPosition;
            }
        };
        this.iTable.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SSVoucherPanel.this.iTable.getSelectedRow() != -1) {
                    SSVoucherRow iRow = (SSVoucherRow)SSVoucherPanel.this.iModel.getObject(SSVoucherPanel.this.iTable.getSelectedRow());
                    if (iRow.getAccount() != null) {
                        List<SSVoucher> iVouchers = SSDB.getInstance().getVouchers();
                        SSNewAccountingYear iYear = SSDB.getInstance().getCurrentYear();
                        BigDecimal iInbalanceSum = iYear.getInBalance(iRow.getAccount());
                        BigDecimal iDebetSum = new BigDecimal(0);
                        BigDecimal iCreditSum = new BigDecimal(0);
                        for (SSVoucher iTempVoucher : iVouchers) {
                            for (SSVoucherRow iTempRow : iTempVoucher.getRows()) {
                                if (iTempRow.getAccountNr() == null || !iTempRow.getAccountNr().equals(iRow.getAccountNr()) || iTempRow.isCrossed()) continue;
                                if (iTempRow.isDebet()) {
                                    iDebetSum = iDebetSum.add(iTempRow.getDebet());
                                    continue;
                                }
                                iCreditSum = iCreditSum.add(iTempRow.getCredit());
                            }
                        }
                        BigDecimal iTotalSum = iInbalanceSum.add(iDebetSum.subtract(iCreditSum));
                        iTotalSum = iTotalSum.setScale(2, RoundingMode.HALF_UP);
                        SSVoucherPanel.this.iSaldo.setValue(iTotalSum);
                    } else {
                        SSVoucherPanel.this.iSaldo.setValue(new BigDecimal(0));
                    }
                }
            }
        });
        this.iDescription.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherPanel.this.iVoucher.setDescription(SSVoucherPanel.this.iDescription.getText());
            }
        });
        this.iDate.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherPanel.this.iVoucher.setDate(SSVoucherPanel.this.iDate.getDate());
            }
        });
        this.iDate.getEditor().getComponent(0).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSVoucherPanel.this.iDescription.getComponent(0).requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iAddAccountButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSVoucherPanel.this.iOkButton.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iOkButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 39) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSVoucherPanel.this.iCancelButton.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iCancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 37) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SSVoucherPanel.this.iOkButton.requestFocusInWindow();
                        }
                    });
                }
            }
        });
        this.iMarkRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherRow iSelected = (SSVoucherRow)SSVoucherPanel.this.iModel.getSelectedRow(SSVoucherPanel.this.iTable);
                String iSignature = SSVoucherPanel.this.getSignature();
                if (iSignature == null) {
                    return;
                }
                iSelected.setCrossed(iSignature);
                SSVoucherPanel.this.iModel.fireTableDataChanged();
            }
        });
        this.iDeleteRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSVoucherRow iSelected = (SSVoucherRow)SSVoucherPanel.this.iModel.getSelectedRow(SSVoucherPanel.this.iTable);
                if (iSelected != null && SSVoucherPanel.this.iModel.allowDeletion(iSelected)) {
                    if (SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "voucherframe.deleterow", iSelected.toString()) != 0) {
                        return;
                    }
                    SSVoucherPanel.this.iModel.deleteRow(iSelected);
                }
            }
        });
        this.iErrorLabel.setVisible(false);
        this.iErrorLabel.setForeground(Color.RED);
        this.iVerifier = new SSVoucherVerifier(this.iOkButton);
        this.iVerifier.setOnUpdate(new SSVoucherVerifier.OnUpdate(){

            @Override
            public void update(boolean valid, String Error2) {
                SSVoucherPanel.this.iErrorLabel.setVisible(!valid);
                SSVoucherPanel.this.iErrorLabel.setText(Error2);
            }
        });
        this.iDifference.addPropertyChangeListener(this.iVerifier);
        this.iDescription.addPropertyChangeListener(this.iVerifier);
        this.iDescription.addChangeListener(this.iVerifier);
        this.iReopenDialog.setSelected((Boolean)SSConfig.getInstance().get("reopen_voucher_dialog", true));
        this.iReopenDialog.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SSConfig.getInstance().set("reopen_voucher_dialog", SSVoucherPanel.this.iReopenDialog.isSelected());
            }
        });
        this.iModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent l) {
                int iRow = l.getFirstRow();
                SSVoucherRow iVoucherRow = (SSVoucherRow)SSVoucherPanel.this.iModel.getObject(iRow);
                if (iAccountChanged) {
                    iAccountChanged = false;
                    SSAutoDist iAutoDist = SSVoucherPanel.this.getAutoDistForAccount(iVoucherRow);
                    if (iAutoDist != null && !iAutoDist.getAmount().equals(new BigDecimal(0)) && SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "voucherframe.doautodist", new Object[0]) == 0) {
                        SSVoucherPanel.this.doAutoDistributionForAmount(iAutoDist, iVoucherRow);
                    }
                } else if (iDebetChanged) {
                    iDebetChanged = false;
                    SSAutoDist iAutoDist = SSVoucherPanel.this.getAutoDistForAccount(iVoucherRow);
                    if (iAutoDist != null && SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "voucherframe.doautodist", new Object[0]) == 0) {
                        SSVoucherPanel.this.doAutoDistributionForRows(iAutoDist, iVoucherRow.getDebet());
                    }
                } else if (iCreditChanged) {
                    iCreditChanged = false;
                    SSAutoDist iAutoDist = SSVoucherPanel.this.getAutoDistForAccount(iVoucherRow);
                    if (iAutoDist != null && SSQueryDialog.showDialog((JFrame)SSMainFrame.getInstance(), SSBundle.getBundle(), "voucherframe.doautodist", new Object[0]) == 0) {
                        SSVoucherPanel.this.doAutoDistributionForRows(iAutoDist, iVoucherRow.getCredit());
                    }
                }
            }
        });
    }

    public boolean doReopen() {
        return this.iReopenDialog.isSelected();
    }

    private SSAutoDist getAutoDistForAccount(SSVoucherRow iVoucherRow) {
        if (iVoucherRow.getAccountNr() != null) {
            for (SSAutoDist iAutoDist : SSDB.getInstance().getAutoDists()) {
                if (!iAutoDist.getNumber().equals(iVoucherRow.getAccountNr())) continue;
                return iAutoDist;
            }
        }
        return null;
    }

    private void doAutoDistributionForRows(SSAutoDist iAutoDist, BigDecimal iValue) {
        BigDecimal iDebet = null;
        BigDecimal iCredit = null;
        SSNewProject iProject = null;
        SSNewResultUnit iResultUnit = null;
        for (SSAutoDistRow iAutoDistRow : iAutoDist.getRows()) {
            SSVoucherRow iVoucherRow = null;
            iProject = iAutoDistRow.getProject();
            iResultUnit = iAutoDistRow.getResultUnit();
            if (iAutoDistRow.getPercentage() != null && iValue != null) {
                if (iAutoDistRow.getPercentage().doubleValue() < 0.0) {
                    BigDecimal iPercent = iAutoDistRow.getPercentage().multiply(new BigDecimal(-1));
                    iCredit = iPercent.divide(new BigDecimal(100)).multiply(iValue);
                    iDebet = null;
                } else if (iAutoDistRow.getPercentage().doubleValue() > 0.0) {
                    iDebet = iAutoDistRow.getPercentage().divide(new BigDecimal(100)).multiply(iValue);
                    iCredit = null;
                }
            } else if (iAutoDistRow.getDebet() != null) {
                iDebet = iAutoDistRow.getDebet();
                iCredit = null;
            } else if (iAutoDistRow.getCredit() != null) {
                iCredit = iAutoDistRow.getCredit();
                iDebet = null;
            }
            iVoucherRow = new SSVoucherRow(iAutoDistRow.getAccount(), iDebet, iCredit, iProject, iResultUnit);
            this.iVoucher.addVoucherRow(iVoucherRow);
        }
    }

    private void doAutoDistributionForAmount(SSAutoDist iAutoDist, SSVoucherRow iRow) {
        this.iVoucher.getRows().remove(iRow);
        BigDecimal iValue = new BigDecimal(0);
        if (iAutoDist.getAmount().doubleValue() < 0.0) {
            iValue = iAutoDist.getAmount().multiply(new BigDecimal(-1));
            iRow.setCredit(iValue);
            iRow.setDebet(null);
        } else if (iAutoDist.getAmount().doubleValue() > 0.0) {
            iValue = iAutoDist.getAmount();
            iRow.setDebet(iValue);
            iRow.setCredit(null);
        }
        this.iVoucher.getRows().add(iRow);
        List<SSVoucherRow> iRows = this.iVoucher.getRows();
        for (SSAutoDistRow iAutoDistRow : iAutoDist.getRows()) {
            BigDecimal iDebet = null;
            BigDecimal iCredit = null;
            SSVoucherRow iVoucherRow = null;
            SSNewProject iProject = iAutoDistRow.getProject();
            SSNewResultUnit iResultUnit = iAutoDistRow.getResultUnit();
            if (iAutoDistRow.getPercentage() != null && iAutoDist.getAmount() != null) {
                if (iAutoDistRow.getPercentage().doubleValue() < 0.0) {
                    BigDecimal iPercent = iAutoDistRow.getPercentage().multiply(new BigDecimal(-1));
                    if (iAutoDist.getAmount().doubleValue() < 0.0) {
                        iCredit = iPercent.divide(new BigDecimal(100)).multiply(iAutoDist.getAmount().multiply(new BigDecimal(-1)));
                        iDebet = null;
                    } else {
                        iCredit = iPercent.divide(new BigDecimal(100)).multiply(iAutoDist.getAmount());
                        iDebet = null;
                    }
                } else if (iAutoDistRow.getPercentage().doubleValue() > 0.0) {
                    if (iAutoDist.getAmount().doubleValue() < 0.0) {
                        iDebet = iAutoDistRow.getPercentage().divide(new BigDecimal(100)).multiply(iAutoDist.getAmount().multiply(new BigDecimal(-1)));
                        iCredit = null;
                    } else {
                        iDebet = iAutoDistRow.getPercentage().divide(new BigDecimal(100)).multiply(iAutoDist.getAmount());
                        iCredit = null;
                    }
                }
            } else if (iAutoDistRow.getDebet() != null) {
                iDebet = iAutoDistRow.getDebet();
                iCredit = null;
            } else if (iAutoDistRow.getCredit() != null) {
                iCredit = iAutoDistRow.getCredit();
                iDebet = null;
            }
            iVoucherRow = new SSVoucherRow(iAutoDistRow.getAccount(), iDebet, iCredit, iProject, iResultUnit);
            iRows.add(iVoucherRow);
        }
        this.iVoucher.setVoucherRows(iRows);
        this.iModel.setObjects(this.iVoucher.getRows());
    }

    public void setVoucher(SSVoucher pVoucher, boolean iEditing, boolean repop) {
        this.iVoucher = pVoucher;
        if (iEditing) {
            if (!repop) {
                this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_EDITED_DATE, true);
                this.iModel.addColumn(SSVoucherRowTableModel.COLUMN_EDITED_SIGNATURE, true);
            }
        } else {
            this.iModel.removeColumn(SSVoucherRowTableModel.COLUMN_EDITED_DATE);
            this.iModel.removeColumn(SSVoucherRowTableModel.COLUMN_EDITED_SIGNATURE);
        }
        this.iModel.setObjects(this.iVoucher.getRows(), iEditing);
        this.iModel.setupTable(this.iTable, true);
        this.iDescription.setText(pVoucher.getDescription());
        this.iNumber.setValue(pVoucher.getNumber());
        this.iDate.setDate(pVoucher.getDate());
        this.iStoreAsTemplate.setSelected(false);
        this.iVerifier.setVoucher(this.iVoucher);
        this.iVerifier.update();
    }

    public SSVoucher getVoucher() {
        return this.iVoucher;
    }

    public boolean isValid() {
        return this.iVerifier.isValid();
    }

    public JPanel getPanel() {
        return this.iPanel;
    }

    public void addOkAction(ActionListener e) {
        this.iOkButton.addActionListener(e);
    }

    public void addCancelAction(ActionListener e) {
        this.iCancelButton.addActionListener(e);
    }

    public void addAddAccountAction(ActionListener e) {
        this.iAddAccountButton.addActionListener(e);
    }

    public void setMarkRowButtonVisible(boolean aFlag) {
        this.iMarkRowButton.setVisible(aFlag);
    }

    public void setDeleteRowButtonVisible(boolean aFlag) {
        this.iDeleteRowButton.setVisible(aFlag);
    }

    public boolean isStoreAsTemplate() {
        return this.iStoreAsTemplate.isSelected();
    }

    public SSDateChooser getDate() {
        return this.iDate;
    }

    private void setDifferenceToZero(SSVoucherRow iVoucherRow) {
        BigDecimal iDebet = iVoucherRow.getDebet();
        BigDecimal iCredit = iVoucherRow.getCredit();
        if ((iDebet == null || iDebet.equals(new BigDecimal(0))) && (iCredit == null || iCredit.equals(new BigDecimal(0)))) {
            BigDecimal iDifference = this.getDifference();
            if (iDifference.signum() < 0) {
                iVoucherRow.setDebet(iDifference.abs());
                iVoucherRow.setCredit(null);
            } else {
                iVoucherRow.setCredit(iDifference.abs());
                iVoucherRow.setDebet(null);
            }
        }
        this.iModel.fireTableDataChanged();
    }

    private BigDecimal getDifference() {
        if (this.iVoucher != null) {
            return SSVoucherMath.getDebetMinusCreditSum(this.iVoucher);
        }
        return new BigDecimal(0);
    }

    public String getSignature() {
        return JOptionPane.showInputDialog(this.iPanel, SSBundle.getBundle().getString("voucherframe.markvoucherrow.message"), SSBundle.getBundle().getString("voucherframe.markvoucherrow.title"), 3);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.iVoucher == null) {
            return;
        }
        this.iVerifier.update();
        BigDecimal debetSum = SSVoucherMath.getDebetSum(this.iVoucher);
        BigDecimal creditSum = SSVoucherMath.getCreditSum(this.iVoucher);
        BigDecimal difference = debetSum.subtract(creditSum);
        this.iDebetSum.setValue(debetSum);
        this.iCreditSum.setValue(creditSum);
        this.iDifference.setValue(difference);
        this.iDifference.setForeground(difference.setScale(2, RoundingMode.HALF_UP).signum() == 0 ? Color.BLACK : Color.RED);
        if (this.iTable.getSelectedColumn() == 0) {
            this.iTable.setColumnSelectionInterval(2, 2);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SSVoucherRow iSelected = (SSVoucherRow)this.iModel.getSelectedRow(this.iTable);
        if (iSelected == null) {
            this.iMarkRowButton.setEnabled(false);
            this.iDeleteRowButton.setEnabled(false);
            return;
        }
        boolean allowDeletion = this.iModel.allowDeletion(iSelected);
        boolean allowMarking = this.iModel.allowMarking(iSelected);
        this.iMarkRowButton.setEnabled(allowMarking);
        this.iDeleteRowButton.setEnabled(allowDeletion);
    }

    public void updateAccounts() {
        this.iModel.setupTable(this.iTable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.panel.SSVoucherPanel");
        sb.append("{iAddAccountButton=").append(this.iAddAccountButton);
        sb.append(", iCancelButton=").append(this.iCancelButton);
        sb.append(", iCreditSum=").append(this.iCreditSum);
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iDebetSum=").append(this.iDebetSum);
        sb.append(", iDeleteRowButton=").append(this.iDeleteRowButton);
        sb.append(", iDescription=").append(this.iDescription);
        sb.append(", iDifference=").append(this.iDifference);
        sb.append(", iErrorLabel=").append(this.iErrorLabel);
        sb.append(", iMarkRowButton=").append(this.iMarkRowButton);
        sb.append(", iModel=").append(this.iModel);
        sb.append(", iNumber=").append(this.iNumber);
        sb.append(", iOkButton=").append(this.iOkButton);
        sb.append(", iPanel=").append(this.iPanel);
        sb.append(", iReopenDialog=").append(this.iReopenDialog);
        sb.append(", iSaldo=").append(this.iSaldo);
        sb.append(", iStoreAsTemplate=").append(this.iStoreAsTemplate);
        sb.append(", iTable=").append(this.iTable);
        sb.append(", iVerifier=").append(this.iVerifier);
        sb.append(", iVoucher=").append(this.iVoucher);
        sb.append(", SSBigDecimalTextField1=").append(this.SSBigDecimalTextField1);
        sb.append(", textField1=").append(this.textField1);
        sb.append('}');
        return sb.toString();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SSButton sSButton;
        JCheckBox jCheckBox;
        SSButton sSButton2;
        SSButton sSButton3;
        JLabel jLabel;
        SSBigDecimalTextField sSBigDecimalTextField;
        JButton jButton;
        JButton jButton2;
        SSDateChooser sSDateChooser;
        JFormattedTextField jFormattedTextField;
        JCheckBox jCheckBox2;
        SSTable sSTable;
        JPanel jPanel;
        this.iPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(5, 4, new Insets(4, 4, 4, 4), -1, -1, false, false));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jScrollPane, new GridConstraints(2, 0, 1, 4, 0, 3, 7, 7, null, null, null));
        this.iTable = sSTable = new SSTable();
        jScrollPane.setViewportView(sSTable);
        this.iStoreAsTemplate = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("book").getString("voucherpanel.storeastemplate"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 5, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("book").getString("voucherpanel.number"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        this.iNumber = jFormattedTextField = new JFormattedTextField();
        jFormattedTextField.setFocusable(false);
        jFormattedTextField.setEditable(false);
        ((Component)jFormattedTextField).setEnabled(true);
        jPanel2.add((Component)jFormattedTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(80, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("book").getString("voucherpanel.description"));
        jPanel2.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        SSTableComboBox sSTableComboBox = new SSTableComboBox();
        this.iDescription = sSTableComboBox;
        jPanel2.add(sSTableComboBox, new GridConstraints(1, 1, 1, 4, 8, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("book").getString("voucherpanel.date"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.iDate = sSDateChooser = new SSDateChooser();
        sSDateChooser.setDateFormatString(ResourceBundle.getBundle("book").getString("date.formatstring"));
        jPanel2.add((Component)sSDateChooser, new GridConstraints(0, 4, 1, 1, 4, 0, 3, 3, new Dimension(150, -1), null, null));
        this.iDeleteRowButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("book").getString("voucherpanel.deleterow"));
        jButton2.setToolTipText(ResourceBundle.getBundle("book").getString("voucherpanel.deleterow"));
        jPanel.add((Component)jButton2, new GridConstraints(1, 3, 1, 1, 0, 1, 3, 0, null, new Dimension(80, -1), null));
        this.iMarkRowButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("book").getString("voucherpanel.markrow"));
        jButton.setToolTipText(ResourceBundle.getBundle("book").getString("voucherpanel.markrow"));
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, new Dimension(80, -1), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 5, new Insets(4, 4, 4, 4), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), 0, 0, false, false));
        ((Component)jPanel4).setEnabled(true);
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 3, null, null, null));
        SSCurrencyTextField sSCurrencyTextField = new SSCurrencyTextField();
        this.iDebetSum = sSCurrencyTextField;
        sSCurrencyTextField.setEditable(false);
        sSCurrencyTextField.setText("0,00");
        jPanel4.add((Component)sSCurrencyTextField, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, new Dimension(100, -1), null, null));
        SSCurrencyTextField sSCurrencyTextField2 = new SSCurrencyTextField();
        this.iCreditSum = sSCurrencyTextField2;
        sSCurrencyTextField2.setEditable(false);
        sSCurrencyTextField2.setText("0,00");
        jPanel4.add((Component)sSCurrencyTextField2, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, new Dimension(100, -1), null, null));
        SSCurrencyTextField sSCurrencyTextField3 = new SSCurrencyTextField();
        this.iDifference = sSCurrencyTextField3;
        sSCurrencyTextField3.setEditable(false);
        sSCurrencyTextField3.setText("0,00");
        jPanel4.add((Component)sSCurrencyTextField3, new GridConstraints(1, 1, 1, 1, 0, 0, 3, 3, new Dimension(100, -1), null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("book").getString("voucherpanel.difference"));
        jLabel5.setInheritsPopupMenu(true);
        jPanel4.add((Component)jLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, new Dimension(80, -1), null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 4, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Saldo:");
        jPanel5.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 5, 0, 0, 0, null, null, null));
        this.iSaldo = sSBigDecimalTextField = new SSBigDecimalTextField();
        sSBigDecimalTextField.setEditable(false);
        jPanel5.add((Component)sSBigDecimalTextField, new GridConstraints(0, 1, 1, 1, 9, 0, 7, 3, null, new Dimension(100, -1), null));
        this.iErrorLabel = jLabel = new JLabel();
        jLabel.setText("Felmeddelande");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 9, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(4, 0, 1, 4, 2, 3, 3, 3, null, null, null));
        this.iOkButton = sSButton3 = new SSButton();
        this.$$$loadButtonText$$$(sSButton3, ResourceBundle.getBundle("book").getString("button.register"));
        jPanel6.add((Component)sSButton3, new GridConstraints(0, 4, 1, 1, 2, 0, 3, 3, new Dimension(100, -1), null, new Dimension(100, -1)));
        this.iCancelButton = sSButton2 = new SSButton();
        this.$$$loadButtonText$$$(sSButton2, ResourceBundle.getBundle("book").getString("button.cancel"));
        jPanel6.add((Component)sSButton2, new GridConstraints(0, 5, 1, 1, 2, 0, 3, 3, new Dimension(100, -1), null, new Dimension(100, -1)));
        this.iReopenDialog = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("book").getString("voucherframe.reopendialog"));
        jPanel6.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.iAddAccountButton = sSButton = new SSButton();
        sSButton.setText("L\u00e4gg till konto");
        jPanel6.add((Component)sSButton, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 3, new Dimension(120, -1), null, new Dimension(120, -1)));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.iPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

