/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.util;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.components.SSTableComboBoxOld;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.SSTableSearchable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSAccountCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSAccountCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSProjectCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSProjectCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSResultUnitCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSResultUnitCellRenderer;

public class SSVoucherEditors {
    public static Color COLOR_CROSSED = new Color(255, 192, 192);
    public static Color COLOR_ADDED = new Color(192, 192, 255);

    private SSVoucherEditors() {
    }

    public static DefaultTableCellRenderer createVoucherRowRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        return new SSDefaultVoucherRowRenderer(pModel);
    }

    public static DefaultTableCellRenderer createAccountRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        return new SSDefaultVoucherRowRenderer<SSAccount>(pModel){

            @Override
            public void setValue(SSAccount value) {
                if (value != null) {
                    this.setText(Integer.toString(value.getNumber()));
                } else {
                    this.setText("");
                }
            }
        };
    }

    public static DefaultTableCellRenderer createResultUnitRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        return new SSDefaultVoucherRowRenderer((SSDefaultTableModel)pModel){

            @Override
            public void setValue(Object value) {
                this.setText(value == null ? "" : ((SSNewResultUnit)value).getNumber());
            }
        };
    }

    public static DefaultTableCellRenderer createProjectRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        return new SSDefaultVoucherRowRenderer((SSDefaultTableModel)pModel){

            @Override
            public void setValue(Object value) {
                this.setText(value == null ? "" : ((SSNewProject)value).getNumber());
            }
        };
    }

    public static DefaultTableCellRenderer createBigDecimalRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        SSDefaultVoucherRowRenderer iEditor = new SSDefaultVoucherRowRenderer((SSDefaultTableModel)pModel){

            @Override
            protected void setValue(Object value) {
                NumberFormat format = NumberFormat.getNumberInstance();
                format.setMinimumFractionDigits(2);
                format.setMaximumFractionDigits(2);
                format.setGroupingUsed(true);
                this.setText(value == null ? "" : format.format(value));
            }
        };
        iEditor.setHorizontalAlignment(4);
        return iEditor;
    }

    public static DefaultTableCellRenderer createDateRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
        return new SSDefaultVoucherRowRenderer((SSDefaultTableModel)pModel){

            @Override
            protected void setValue(Object value) {
                DateFormat format = DateFormat.getDateInstance(3);
                this.setText(value != null ? format.format((Date)value) : "");
            }
        };
    }

    public static TableCellEditor createAccountEditor() {
        SSDefaultTableModel<SSAccount> model = new SSDefaultTableModel<SSAccount>(SSDB.getInstance().getCurrentYear().getActiveAccounts()){

            @Override
            public Class getType() {
                return SSAccount.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSAccount account = (SSAccount)this.getObject(rowIndex);
                Object value = null;
                switch (columnIndex) {
                    case 0: {
                        value = account.getNumber();
                        break;
                    }
                    case 1: {
                        value = account.getDescription();
                    }
                }
                return value;
            }
        };
        model.addColumn(SSBundle.getBundle().getString("accounttable.column.1"));
        model.addColumn(SSBundle.getBundle().getString("accounttable.column.2"));
        SSTableComboBoxOld.CellEditor<SSAccount> iEditor = SSTableComboBoxOld.createAsCellEditor(model);
        iEditor.setSearchColumns(0, 1);
        iEditor.setPopupSize(360, 200);
        iEditor.setColumnWidths(60, 300);
        return iEditor;
    }

    public static TableCellEditor createProjectEditor() {
        SSDefaultTableModel<SSNewProject> model = new SSDefaultTableModel<SSNewProject>(SSDB.getInstance().getProjects()){

            @Override
            public Class getType() {
                return SSNewProject.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSNewProject project = (SSNewProject)this.getObject(rowIndex);
                String value = null;
                switch (columnIndex) {
                    case 0: {
                        value = project.getNumber();
                        break;
                    }
                    case 1: {
                        value = project.getName();
                        break;
                    }
                    case 2: {
                        value = project.getDescription();
                    }
                }
                return value;
            }
        };
        model.addColumn(SSBundle.getBundle().getString("projecttable.column.1"));
        model.addColumn(SSBundle.getBundle().getString("projecttable.column.2"));
        model.addColumn(SSBundle.getBundle().getString("projecttable.column.3"));
        SSTableComboBoxOld.CellEditor<SSNewProject> iEditor = SSTableComboBoxOld.createAsCellEditor(model);
        iEditor.setSearchColumns(0);
        iEditor.setPopupSize(360, 200);
        iEditor.setColumnWidths(60, 100, 200);
        return iEditor;
    }

    public static TableCellEditor createResultUnitEditor() {
        SSDefaultTableModel<SSNewResultUnit> model = new SSDefaultTableModel<SSNewResultUnit>(SSDB.getInstance().getResultUnits()){

            @Override
            public Class getType() {
                return SSNewResultUnit.class;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                SSNewResultUnit resultUnit = (SSNewResultUnit)this.getObject(rowIndex);
                String value = null;
                switch (columnIndex) {
                    case 0: {
                        value = resultUnit.getNumber();
                        break;
                    }
                    case 1: {
                        value = resultUnit.getName();
                    }
                }
                return value;
            }
        };
        model.addColumn(SSBundle.getBundle().getString("resultunittable.column.1"));
        model.addColumn(SSBundle.getBundle().getString("resultunittable.column.2"));
        SSTableComboBoxOld.CellEditor<SSNewResultUnit> iEditor = SSTableComboBoxOld.createAsCellEditor(model);
        iEditor.setSearchColumns(0);
        iEditor.setPopupSize(360, 200);
        iEditor.setColumnWidths(60, 300);
        return iEditor;
    }

    public static void setupVoucherRowTable(SSTable pTable, SSDefaultTableModel<SSVoucherRow> pModel) {
        pTable.setShowHorizontalLines(true);
        pTable.setShowVerticalLines(true);
        pTable.setColumnSortingEnabled(false);
        pTable.getTableHeader().setReorderingAllowed(false);
        pTable.setDefaultRenderer(SSAccount.class, new SSAccountCellRenderer());
        pTable.setDefaultEditor(SSAccount.class, new SSAccountCellEditor());
        pTable.setDefaultRenderer(SSNewProject.class, new SSProjectCellRenderer());
        pTable.setDefaultEditor(SSNewProject.class, new SSProjectCellEditor());
        pTable.setDefaultRenderer(SSNewResultUnit.class, new SSResultUnitCellRenderer());
        pTable.setDefaultEditor(SSNewResultUnit.class, new SSResultUnitCellEditor());
        pTable.setDefaultRenderer(Date.class, new SSDateCellRenderer());
        pTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
        pTable.setDefaultEditor(BigDecimal.class, new SSBigDecimalCellEditor(2));
        pTable.setModel(pModel);
        try {
            pTable.getColumnModel().getColumn(0).setPreferredWidth(65);
            pTable.getColumnModel().getColumn(1).setPreferredWidth(240);
            pTable.getColumnModel().getColumn(2).setPreferredWidth(85);
            pTable.getColumnModel().getColumn(3).setPreferredWidth(85);
            pTable.getColumnModel().getColumn(4).setPreferredWidth(85);
            pTable.getColumnModel().getColumn(5).setPreferredWidth(85);
            if (pTable.getColumnModel().getColumnCount() == 8) {
                pTable.getColumnModel().getColumn(6).setPreferredWidth(70);
                pTable.getColumnModel().getColumn(7).setPreferredWidth(65);
            } else {
                pTable.getColumnModel().getColumn(1).setPreferredWidth(376);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class SSDefaultVoucherRowRenderer<T extends SSTableSearchable>
    extends DefaultTableCellRenderer {
        private SSDefaultTableModel<SSVoucherRow> iModel;

        public SSDefaultVoucherRowRenderer(SSDefaultTableModel<SSVoucherRow> pModel) {
            this.iModel = pModel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SSVoucherRow iRow = this.iModel.getObject(row);
            if (iRow.isCrossed()) {
                c.setBackground(COLOR_CROSSED);
            } else if (iRow.isAdded()) {
                c.setBackground(COLOR_ADDED);
            } else if (!isSelected) {
                c.setBackground(Color.WHITE);
            }
            return c;
        }

        @Override
        protected void setValue(Object value) {
            if (value instanceof SSTableSearchable) {
                this.setValue(value);
            } else {
                super.setValue(value);
            }
        }

        protected void setValue(T value) {
            super.setValue(value);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherEditors.SSDefaultVoucherRowRenderer");
            sb.append("{iModel=").append(this.iModel);
            sb.append('}');
            return sb.toString();
        }
    }
}

