/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.gui.voucher.util;

import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.JTable;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.model.SSDefaultTableModel;
import se.swedsoft.bookkeeping.gui.util.table.SSTable;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSAccountCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSAccountCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSBigDecimalCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSDateCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSProjectCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSProjectCellRenderer;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSResultUnitCellEditor;
import se.swedsoft.bookkeeping.gui.util.table.editors.SSResultUnitCellRenderer;

public class SSVoucherRowTableModelOld
extends SSDefaultTableModel<SSVoucherRow> {
    public static final int COL_ACCOUNT = 0;
    public static final int COL_DESCRIPTION = 1;
    public static final int COL_DEBET = 2;
    public static final int COL_CREDIT = 3;
    public static final int COL_PROJECT = 4;
    public static final int COL_RESULTUNIT = 5;
    public static final int COL_EDITED_DATE = 6;
    public static final int COL_EDITED_SIGNATURE = 7;
    private boolean iEdit;
    private boolean iReadOnly;
    private int iReadOnlyRowCount;
    private SSVoucherRow iEditingRow;
    public static Color COLOR_CROSSED = new Color(255, 192, 192);
    public static Color COLOR_ADDED = new Color(192, 192, 255);

    public SSVoucherRowTableModelOld(boolean pEdit, boolean pReadOnly) {
        this.iEdit = pEdit;
        this.iReadOnly = pReadOnly;
        this.iReadOnlyRowCount = 0;
        this.iEditingRow = new SSVoucherRow();
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.1"));
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.2"));
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.3"));
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.4"));
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.5"));
        this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.6"));
        if (pEdit) {
            this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.7"));
            this.addColumn(SSBundle.getBundle().getString("voucherrowtable.column.8"));
        }
        this.setObjects(new LinkedList());
    }

    public void setVoucher(SSVoucher iVoucher) {
        this.setObjects(iVoucher.getRows());
        this.iReadOnlyRowCount = super.getRowCount();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        if (this.iReadOnly) {
            return super.getRowCount();
        }
        return super.getRowCount() + 1;
    }

    @Override
    public SSVoucherRow getObject(int row) {
        if (row >= super.getRowCount()) {
            return this.iEditingRow;
        }
        return (SSVoucherRow)super.getObject(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        SSVoucherRow iRow = this.getObject(rowIndex);
        if (this.iReadOnly) {
            return false;
        }
        if (columnIndex == 1 || columnIndex == 6) {
            return false;
        }
        if (this.iEdit && rowIndex < this.iReadOnlyRowCount) {
            return false;
        }
        if (columnIndex == 0) {
            return true;
        }
        return iRow != null && iRow.getAccount() != null;
    }

    @Override
    public Class getType() {
        return SSVoucherRow.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SSVoucherRow iVoucherRow = this.getObject(rowIndex);
        SSAccount iAccount = iVoucherRow.getAccount();
        Object value = null;
        switch (columnIndex) {
            case 0: {
                value = iAccount;
                break;
            }
            case 1: {
                value = iAccount != null ? iAccount.getDescription() : null;
                break;
            }
            case 2: {
                value = iVoucherRow.getDebet();
                break;
            }
            case 3: {
                value = iVoucherRow.getCredit();
                break;
            }
            case 4: {
                value = iVoucherRow.getProject();
                break;
            }
            case 5: {
                value = iVoucherRow.getResultUnit();
                break;
            }
            case 6: {
                value = iVoucherRow.getEditedDate();
                break;
            }
            case 7: {
                value = iVoucherRow.getEditedSignature();
            }
        }
        return value;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SSVoucherRow iVoucherRow = this.getObject(rowIndex);
        switch (columnIndex) {
            case 0: {
                if (!(aValue instanceof SSAccount)) break;
                iVoucherRow.setAccount((SSAccount)aValue);
                break;
            }
            case 2: {
                iVoucherRow.setDebet((BigDecimal)aValue);
                iVoucherRow.setCredit(null);
                this.fireTableCellUpdated(rowIndex, 3);
                break;
            }
            case 3: {
                iVoucherRow.setCredit((BigDecimal)aValue);
                iVoucherRow.setDebet(null);
                this.fireTableCellUpdated(rowIndex, 2);
                break;
            }
            case 4: {
                iVoucherRow.setProject((SSNewProject)aValue);
                break;
            }
            case 5: {
                iVoucherRow.setResultUnit((SSNewResultUnit)aValue);
                break;
            }
            case 7: {
                iVoucherRow.setEditedSignature((String)aValue);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
        if (iVoucherRow == this.iEditingRow && aValue != null && !"".equals(aValue)) {
            if (this.iEdit) {
                this.iEditingRow.setAdded(null);
                this.iEditingRow.setEditedDate(new Date());
            }
            this.add(this.iEditingRow);
            this.iEditingRow = new SSVoucherRow();
            this.fireTableDataChanged();
        }
    }

    @Override
    public int getColumnCount() {
        int count = super.getColumnCount();
        return this.iEdit ? count : Math.min(count, 6);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return SSAccount.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return BigDecimal.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 4: {
                return SSNewProject.class;
            }
            case 5: {
                return SSNewResultUnit.class;
            }
            case 6: {
                return Date.class;
            }
            case 7: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public void deleteRow(SSVoucherRow iSelected) {
        if (this.iReadOnly) {
            return;
        }
        if (iSelected == this.iEditingRow) {
            this.iEditingRow = new SSVoucherRow();
        }
        if (this.iEdit && this.indexOf(iSelected) < this.iReadOnlyRowCount) {
            return;
        }
        super.delete(iSelected);
    }

    public boolean canDeleteRow(SSVoucherRow iSelected) {
        return !this.iReadOnly && (!this.iEdit || this.indexOf(iSelected) >= this.iReadOnlyRowCount) || iSelected == this.iEditingRow;
    }

    public static void setupTable(SSTable iTable, final SSDefaultTableModel<SSVoucherRow> iModel) {
        iTable.setColumnSortingEnabled(false);
        iTable.getTableHeader().setReorderingAllowed(false);
        iTable.setCustomPainter(new SSTable.SSCustomPainter(){

            @Override
            public void update(JTable iTable, Component c, int row, int col, boolean selected, boolean editable) {
                SSVoucherRow iRow = (SSVoucherRow)iModel.getObject(row);
                if (iRow.isCrossed()) {
                    c.setBackground(COLOR_CROSSED);
                } else if (iRow.isAdded()) {
                    c.setBackground(COLOR_ADDED);
                } else if (selected) {
                    c.setBackground(iTable.getSelectionBackground());
                } else {
                    c.setBackground(iTable.getBackground());
                }
            }
        });
        iTable.setDefaultRenderer(SSAccount.class, new SSAccountCellRenderer());
        iTable.setDefaultEditor(SSAccount.class, new SSAccountCellEditor());
        iTable.setDefaultRenderer(SSNewProject.class, new SSProjectCellRenderer());
        iTable.setDefaultEditor(SSNewProject.class, new SSProjectCellEditor());
        iTable.setDefaultRenderer(SSNewResultUnit.class, new SSResultUnitCellRenderer());
        iTable.setDefaultEditor(SSNewResultUnit.class, new SSResultUnitCellEditor());
        iTable.setDefaultRenderer(Date.class, new SSDateCellRenderer());
        iTable.setDefaultRenderer(BigDecimal.class, new SSBigDecimalCellRenderer(2));
        iTable.setDefaultEditor(BigDecimal.class, new SSBigDecimalCellEditor(2));
        try {
            iTable.getColumnModel().getColumn(0).setPreferredWidth(57);
            iTable.getColumnModel().getColumn(1).setPreferredWidth(240);
            iTable.getColumnModel().getColumn(2).setPreferredWidth(85);
            iTable.getColumnModel().getColumn(3).setPreferredWidth(85);
            iTable.getColumnModel().getColumn(4).setPreferredWidth(85);
            iTable.getColumnModel().getColumn(5).setPreferredWidth(85);
            if (iTable.getColumnModel().getColumnCount() == 8) {
                iTable.getColumnModel().getColumn(6).setPreferredWidth(70);
                iTable.getColumnModel().getColumn(7).setPreferredWidth(65);
            } else {
                iTable.getColumnModel().getColumn(1).setPreferredWidth(376);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.gui.voucher.util.SSVoucherRowTableModelOld");
        sb.append("{iEdit=").append(this.iEdit);
        sb.append(", iEditingRow=").append(this.iEditingRow);
        sb.append(", iReadOnly=").append(this.iReadOnly);
        sb.append(", iReadOnlyRowCount=").append(this.iReadOnlyRowCount);
        sb.append('}');
        return sb.toString();
    }
}

