/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.bgmax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSInvoiceMath;
import se.swedsoft.bookkeeping.data.SSInpayment;
import se.swedsoft.bookkeeping.data.SSInpaymentRow;
import se.swedsoft.bookkeeping.data.SSInvoice;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxAvsnitt;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxBetalning;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxFile;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxReferens;
import se.swedsoft.bookkeeping.importexport.bgmax.dialog.BgMaxSelectInvoiceDialog;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSBgMaxImporter {
    private SSBgMaxImporter() {
    }

    public static BgMaxFile Import(File iFile) throws SSImportException {
        LinkedList<String> iLines = new LinkedList<String>();
        try {
            String iLine;
            BufferedReader iReader = new BufferedReader(new FileReader(iFile));
            while ((iLine = iReader.readLine()) != null) {
                iLines.add(iLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BgMaxFile iBgMaxFile = new BgMaxFile();
        iBgMaxFile.parse(iLines);
        System.out.println(iBgMaxFile);
        return iBgMaxFile;
    }

    public static List<SSInpayment> getInpayments(SSMainFrame iMainFrame, BgMaxFile iBgMaxFile) {
        BgMaxSelectInvoiceDialog iDialog = new BgMaxSelectInvoiceDialog(iMainFrame);
        iDialog.setLocationRelativeTo(iMainFrame);
        SimpleDateFormat iDateFormat = new SimpleDateFormat("yyyyMMdd");
        LinkedList<SSInpayment> iInpayments = new LinkedList<SSInpayment>();
        for (BgMaxAvsnitt iAvsnitt : iBgMaxFile.iAvsnitts) {
            SSInpayment iInpayment = new SSInpayment();
            iInpayment.setText("Bankgiro inbetalning " + iAvsnitt.iLopnummer);
            try {
                iInpayment.setDate(iDateFormat.parse(iAvsnitt.iBetalningsdag));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            for (BgMaxBetalning iBetalning : iAvsnitt.iBetalningar) {
                SSInvoice iInvoice = SSInvoiceMath.getInvoiceByReference(iBetalning.iReferens);
                if (iInvoice == null && !iBetalning.iReferenser.isEmpty()) {
                    for (BgMaxReferens iReferens : iBetalning.iReferenser) {
                        iInvoice = SSInvoiceMath.getInvoiceByReference(iReferens.iReferens);
                    }
                }
                if (iInvoice == null) {
                    int iResponce = iDialog.showDialog(iBetalning);
                    if (iResponce != 0) {
                        return null;
                    }
                    iInvoice = iDialog.getInvoice();
                }
                SSInpaymentRow iInpaymentRow = new SSInpaymentRow();
                iInpaymentRow.setCurrencyRate(new BigDecimal(1));
                iInpaymentRow.setInvoice(iInvoice);
                iInpaymentRow.setValue(iBetalning.getBelopp());
                iInpayment.getRows().add(iInpaymentRow);
            }
            iInpayments.add(iInpayment);
        }
        return iInpayments;
    }
}

