/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.bgmax.data;

import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxAvsnitt;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxBetalning;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxLine;
import se.swedsoft.bookkeeping.importexport.bgmax.data.BgMaxReferens;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class BgMaxFile {
    public String iLayoutnamn;
    public String iVersion;
    public String iTidsstampel;
    public String iTestmarkering;
    public String iAntalBetalningsPoster;
    public String iAntalExtraReferensPoster;
    public String iAntalAvdragsPoster;
    public String iAntalInsattningsPoster;
    public List<BgMaxAvsnitt> iAvsnitts = new LinkedList<BgMaxAvsnitt>();

    public void parse(List<String> iLines) throws SSImportException {
        this.iAvsnitts = new LinkedList<BgMaxAvsnitt>();
        if (iLines.size() < 1 || !this.isValid(iLines.get(0))) {
            throw new SSImportException(SSBundle.getBundle(), "bgmaximport.error.invalidfile");
        }
        boolean foundEmptyLine = false;
        for (String line : iLines) {
            if (line.length() == 0) {
                foundEmptyLine = true;
                continue;
            }
            if (foundEmptyLine) {
                System.err.println("Empty line in the middle of the file");
                throw new SSImportException(SSBundle.getBundle(), "bgmaximport.error.parseerror");
            }
            BgMaxLine iBgMaxLine = new BgMaxLine(line);
            this.parseLine(iBgMaxLine);
        }
    }

    private boolean isValid(String iFirstLine) {
        return iFirstLine.length() == 80 && iFirstLine.startsWith("01BGMAX");
    }

    private void parseLine(BgMaxLine iLine) {
        BgMaxBetalning iBetalning;
        BgMaxAvsnitt iAvsnitt;
        String iTransaktionsKod = iLine.getTransaktionsKod();
        if (iTransaktionsKod.equals("05")) {
            iAvsnitt = new BgMaxAvsnitt();
            this.iAvsnitts.add(iAvsnitt);
        } else {
            iAvsnitt = !this.iAvsnitts.isEmpty() ? this.iAvsnitts.get(this.iAvsnitts.size() - 1) : null;
        }
        if (iAvsnitt != null) {
            if (iTransaktionsKod.equals("20") || iTransaktionsKod.equals("21")) {
                iBetalning = new BgMaxBetalning();
                iBetalning.iAvsnitt = iAvsnitt;
                iAvsnitt.iBetalningar.add(iBetalning);
            } else {
                iBetalning = !iAvsnitt.iBetalningar.isEmpty() ? iAvsnitt.iBetalningar.get(iAvsnitt.iBetalningar.size() - 1) : null;
            }
        } else {
            iBetalning = null;
        }
        if (iTransaktionsKod.equals("01")) {
            BgMaxFile.readStartPost(iLine, this);
        } else if (iTransaktionsKod.equals("70")) {
            BgMaxFile.readSlutPost(iLine, this);
        } else if (iTransaktionsKod.equals("05")) {
            BgMaxFile.readOppningsPost(iLine, iAvsnitt);
        } else if (iTransaktionsKod.equals("15")) {
            BgMaxFile.readInsattningsPost(iLine, iAvsnitt);
        } else if (iTransaktionsKod.equals("20")) {
            BgMaxFile.readBetalningsPost(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("21")) {
            BgMaxFile.readAvdragsPost(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("22")) {
            BgMaxFile.readExtraReferensPost(iLine, iBetalning, false);
        } else if (iTransaktionsKod.equals("23")) {
            BgMaxFile.readExtraReferensPost(iLine, iBetalning, true);
        } else if (iTransaktionsKod.equals("25")) {
            BgMaxFile.readInformationsPost(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("26")) {
            BgMaxFile.readNamnPost(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("27")) {
            BgMaxFile.readAddressPost1(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("28")) {
            BgMaxFile.readAddressPost2(iLine, iBetalning);
        } else if (iTransaktionsKod.equals("29")) {
            BgMaxFile.readOrgnummerPost(iLine, iBetalning);
        } else {
            System.out.println("No reader for: " + iTransaktionsKod);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BgMaxFil: {\n");
        sb.append("  Layoutnamn    : ").append(this.iLayoutnamn).append('\n');
        sb.append("  Version       : ").append(this.iVersion).append('\n');
        sb.append("  Tidsst\u00e4mpel   : ").append(this.iTidsstampel).append('\n');
        sb.append("  Testmarkering : ").append(this.iTestmarkering).append('\n');
        for (BgMaxAvsnitt iCurrent : this.iAvsnitts) {
            sb.append(iCurrent);
        }
        sb.append("  iAntalBetalningsPoster    : ").append(this.iAntalBetalningsPoster).append('\n');
        sb.append("  iAntalAvdragsPoster       : ").append(this.iAntalAvdragsPoster).append('\n');
        sb.append("  iAntalExtraReferensPoster : ").append(this.iAntalExtraReferensPoster).append('\n');
        sb.append("  iAntalInsattningsPoster   : ").append(this.iAntalInsattningsPoster).append('\n');
        sb.append("}\n");
        return sb.toString();
    }

    public static void readStartPost(BgMaxLine iLine, BgMaxFile iFile) {
        iFile.iLayoutnamn = iLine.getField(3, 22);
        iFile.iVersion = iLine.getField(23, 24);
        iFile.iTidsstampel = iLine.getField(25, 44);
        iFile.iTestmarkering = iLine.getField(45);
    }

    private static void readSlutPost(BgMaxLine iLine, BgMaxFile iFile) {
        iFile.iAntalBetalningsPoster = iLine.getField(3, 10);
        iFile.iAntalExtraReferensPoster = iLine.getField(19, 26);
        iFile.iAntalAvdragsPoster = iLine.getField(11, 18);
        iFile.iAntalInsattningsPoster = iLine.getField(27, 34);
    }

    public static void readOppningsPost(BgMaxLine iLine, BgMaxAvsnitt iAvsnitt) {
        iAvsnitt.iPlusgiroNummer = iLine.getField(13, 22);
        iAvsnitt.iBankgiroNummer = iLine.getField(3, 12);
        iAvsnitt.iValuta = iLine.getField(23, 25);
    }

    private static void readInsattningsPost(BgMaxLine iLine, BgMaxAvsnitt iAvsnitt) {
        iAvsnitt.iBankKontoNummer = iLine.getField(3, 37);
        iAvsnitt.iBetalningsdag = iLine.getField(38, 45);
        iAvsnitt.iLopnummer = iLine.getField(46, 50);
        iAvsnitt.iBelopp = iLine.getField(51, 65);
        iAvsnitt.iValuta = iLine.getField(69, 71);
        iAvsnitt.iAntal = iLine.getField(72, 79);
        iAvsnitt.iTyp = iLine.getField(80);
    }

    public static void readBetalningsPost(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBankgiroNummer = iLine.getField(3, 12);
        iBetalning.iReferens = iLine.getField(13, 37);
        iBetalning.iBelopp = iLine.getField(38, 55);
        iBetalning.iReferensKod = iLine.getField(56);
        iBetalning.iBetalningsKanalKod = iLine.getField(57);
        iBetalning.iBGCLopnummer = iLine.getField(58, 69);
        iBetalning.iAvibildmarkering = iLine.getField(70);
    }

    public static void readAvdragsPost(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBankgiroNummer = iLine.getField(3, 12);
        iBetalning.iReferens = iLine.getField(13, 37);
        iBetalning.iBelopp = '-' + iLine.getField(38, 55);
        iBetalning.iReferensKod = iLine.getField(56);
        iBetalning.iBetalningsKanalKod = iLine.getField(57);
        iBetalning.iBGCLopnummer = iLine.getField(58, 69);
        iBetalning.iAvibildmarkering = iLine.getField(70);
    }

    private static void readExtraReferensPost(BgMaxLine iLine, BgMaxBetalning iBetalning, boolean iNegative) {
        String iBankgiroNummer = iLine.getField(3, 12);
        String iReferens = iLine.getField(13, 37);
        String iBelopp = iLine.getField(38, 55);
        String iReferensKod = iLine.getField(56);
        String iBetalningsKanalKod = iLine.getField(57);
        String iBGCLopnummer = iLine.getField(58, 69);
        String iAvibildmarkering = iLine.getField(70);
        BgMaxReferens iBgMaxReferens = new BgMaxReferens();
        iBgMaxReferens.iBankgiroNummer = iBankgiroNummer;
        iBgMaxReferens.iReferens = iReferens;
        iBgMaxReferens.iBelopp = iBelopp;
        iBgMaxReferens.iReferensKod = iReferensKod;
        iBgMaxReferens.iBetalningsKanalKod = iBetalningsKanalKod;
        iBgMaxReferens.iBGCLopnummer = iBGCLopnummer;
        iBgMaxReferens.iAvibildmarkering = iAvibildmarkering;
        iBetalning.iReferenser.add(iBgMaxReferens);
    }

    private static void readInformationsPost(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        String iInformationsText = iLine.getField(3, 52);
        iBetalning.iInformationsText = iBetalning.iInformationsText == null ? iInformationsText : iBetalning.iInformationsText + iInformationsText;
    }

    private static void readNamnPost(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBetalarensNamn = iLine.getField(3, 27);
        iBetalning.iExtraNamnfalt = iLine.getField(38, 72);
    }

    private static void readAddressPost1(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBetalarensAdress = iLine.getField(3, 37);
        iBetalning.iBetalarensPostnummer = iLine.getField(38, 46);
    }

    private static void readAddressPost2(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBetalarensOrt = iLine.getField(3, 37);
        iBetalning.iBetalarensLand = iLine.getField(38, 72);
        iBetalning.iLandKod = iLine.getField(73, 74);
    }

    private static void readOrgnummerPost(BgMaxLine iLine, BgMaxBetalning iBetalning) {
        iBetalning.iBetalarensOrganisationsnr = iLine.getField(3, 14);
    }
}

