/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import se.swedsoft.bookkeeping.calc.math.SSSupplierMath;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSInitDialog;
import se.swedsoft.bookkeeping.importexport.dialog.SSImportReportDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSSupplierImporter {
    private File iFile;
    private Map<String, Integer> iColumns;

    public SSSupplierImporter(File iFile) {
        this.iFile = iFile;
        this.iColumns = new HashMap<String, Integer>();
    }

    public void Import() throws IOException, SSImportException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        LinkedList<SSSupplier> iSuppliers = new LinkedList();
        try {
            Workbook iWorkbook = Workbook.getWorkbook(this.iFile, iSettings);
            if (iWorkbook.getNumberOfSheets() == 0) {
                throw new SSImportException(SSBundle.getBundle(), "supplierframe.import.nosheets");
            }
            Sheet iSheet = iWorkbook.getSheet(0);
            iSuppliers = this.importSuppliers(new SSExcelSheet(iSheet));
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        final LinkedList iNewSuppliers = new LinkedList(iSuppliers);
        final boolean iResult = this.showImportReport(iSuppliers);
        SSInitDialog.runProgress(SSMainFrame.getInstance(), "Importerar leverant\ufffdrer", new Runnable(){

            @Override
            public void run() {
                if (iNewSuppliers != null && iResult) {
                    Integer iOutPaymentNumber = SSSupplierMath.getOutpaymentNumber();
                    for (SSSupplier iSupplier : iNewSuppliers) {
                        if (SSDB.getInstance().getSuppliers().contains(iSupplier)) continue;
                        iSupplier.setOutpaymentNumber(iOutPaymentNumber);
                        SSDB.getInstance().addSupplier(iSupplier);
                        Integer n = iOutPaymentNumber;
                        Integer n2 = iOutPaymentNumber = Integer.valueOf(iOutPaymentNumber + 1);
                    }
                }
            }
        });
    }

    private void getColumnIndexes(SSExcelRow iColumns) {
        this.iColumns.clear();
        int iIndex = 0;
        for (SSExcelCell iColumn : iColumns.getCells()) {
            String iName = iColumn.getString();
            if (iName != null && iName.length() > 0) {
                if (iName.equalsIgnoreCase("Leverant\u00f6rs-id")) {
                    this.iColumns.put("Leverant\u00f6rs-id", iIndex);
                } else if (iName.equalsIgnoreCase("Namn")) {
                    this.iColumns.put("Namn", iIndex);
                } else if (iName.equalsIgnoreCase("Telefon1")) {
                    this.iColumns.put("Telefon1", iIndex);
                } else if (iName.equalsIgnoreCase("Telefon2")) {
                    this.iColumns.put("Telefon2", iIndex);
                } else if (iName.equalsIgnoreCase("Fax")) {
                    this.iColumns.put("Fax", iIndex);
                } else if (iName.equalsIgnoreCase("Epost")) {
                    this.iColumns.put("Epost", iIndex);
                } else if (iName.equalsIgnoreCase("Hemsida")) {
                    this.iColumns.put("Hemsida", iIndex);
                } else if (iName.equalsIgnoreCase("Kontaktperson")) {
                    this.iColumns.put("Kontaktperson", iIndex);
                } else if (iName.equalsIgnoreCase("Organisationsnummer")) {
                    this.iColumns.put("Organisationsnummer", iIndex);
                } else if (iName.equalsIgnoreCase("V\u00e5rt kundnummer")) {
                    this.iColumns.put("V\u00e5rt kundnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Bankgiro")) {
                    this.iColumns.put("Bankgiro", iIndex);
                } else if (iName.equalsIgnoreCase("Plusgiro")) {
                    this.iColumns.put("Plusgiro", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Namn")) {
                    this.iColumns.put("Adress.Namn", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Adress1")) {
                    this.iColumns.put("Adress.Adress1", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Adress2")) {
                    this.iColumns.put("Adress.Adress2", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Postnummer")) {
                    this.iColumns.put("Adress.Postnummer", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Postort")) {
                    this.iColumns.put("Adress.Postort", iIndex);
                } else if (iName.equalsIgnoreCase("Adress.Land")) {
                    this.iColumns.put("Adress.Land", iIndex);
                } else {
                    throw new SSImportException("Ogiltigt kolumnnamn i importfilen: %s", iName);
                }
            }
            ++iIndex;
        }
    }

    private List<SSSupplier> importSuppliers(SSExcelSheet pSheet) {
        List<SSExcelRow> iRows = pSheet.getRows();
        if (iRows.size() < 2) {
            throw new SSImportException(SSBundle.getBundle(), "supplierframe.import.norows");
        }
        this.getColumnIndexes(iRows.get(0));
        LinkedList<SSSupplier> iSuppliers = new LinkedList<SSSupplier>();
        for (int row = 1; row < iRows.size(); ++row) {
            SSExcelRow iRow = iRows.get(row);
            if (iRow.empty()) continue;
            List<SSExcelCell> iCells = iRow.getCells();
            SSSupplier iSupplier = new SSSupplier();
            for (int col = 0; col < iCells.size(); ++col) {
                SSExcelCell iCell = iCells.get(col);
                String iValue = iCell.getString();
                if (this.iColumns.containsKey("Leverant\u00f6rs-id") && this.iColumns.get("Leverant\u00f6rs-id") == col) {
                    iSupplier.setNumber(iValue);
                }
                if (this.iColumns.containsKey("Namn") && this.iColumns.get("Namn") == col) {
                    iSupplier.setName(iValue);
                }
                if (this.iColumns.containsKey("Telefon1") && this.iColumns.get("Telefon1") == col) {
                    iSupplier.setPhone1(iValue);
                }
                if (this.iColumns.containsKey("Telefon2") && this.iColumns.get("Telefon2") == col) {
                    iSupplier.setPhone2(iValue);
                }
                if (this.iColumns.containsKey("Fax") && this.iColumns.get("Fax") == col) {
                    iSupplier.setTelefax(iValue);
                }
                if (this.iColumns.containsKey("Epost") && this.iColumns.get("Epost") == col) {
                    iSupplier.setEMail(iValue);
                }
                if (this.iColumns.containsKey("Hemsida") && this.iColumns.get("Hemsida") == col) {
                    iSupplier.setHomepage(iValue);
                }
                if (this.iColumns.containsKey("Kontaktperson") && this.iColumns.get("Kontaktperson") == col) {
                    iSupplier.setYourContact(iValue);
                }
                if (this.iColumns.containsKey("Organisationsnummer") && this.iColumns.get("Organisationsnummer") == col) {
                    iSupplier.setRegistrationNumber(iValue);
                }
                if (this.iColumns.containsKey("V\u00e5rt kundnummer") && this.iColumns.get("V\u00e5rt kundnummer") == col) {
                    iSupplier.setOurCustomerNr(iValue);
                }
                if (this.iColumns.containsKey("Bankgiro") && this.iColumns.get("Bankgiro") == col) {
                    iSupplier.setBankGiro(iValue);
                }
                if (this.iColumns.containsKey("Plusgiro") && this.iColumns.get("Plusgiro") == col) {
                    iSupplier.setPlusGiro(iValue);
                }
                if (this.iColumns.containsKey("Adress.Namn") && this.iColumns.get("Adress.Namn") == col) {
                    iSupplier.getAddress().setName(iValue);
                }
                if (this.iColumns.containsKey("Adress.Adress1") && this.iColumns.get("Adress.Adress1") == col) {
                    iSupplier.getAddress().setAddress1(iValue);
                }
                if (this.iColumns.containsKey("Adress.Adress2") && this.iColumns.get("Adress.Adress2") == col) {
                    iSupplier.getAddress().setAddress2(iValue);
                }
                if (this.iColumns.containsKey("Adress.Postnummer") && this.iColumns.get("Adress.Postnummer") == col) {
                    iSupplier.getAddress().setZipCode(iValue);
                }
                if (this.iColumns.containsKey("Adress.Postort") && this.iColumns.get("Adress.Postort") == col) {
                    iSupplier.getAddress().setCity(iValue);
                }
                if (!this.iColumns.containsKey("Adress.Land") || this.iColumns.get("Adress.Land") != col) continue;
                iSupplier.getAddress().setCountry(iValue);
            }
            if (iSupplier.getNumber() == null || iSupplier.getNumber().length() <= 0) continue;
            iSuppliers.add(iSupplier);
        }
        return iSuppliers;
    }

    private boolean showImportReport(List<SSSupplier> iSuppliers) {
        SSImportReportDialog iDialog = new SSImportReportDialog(SSMainFrame.getInstance(), SSBundle.getBundle().getString("supplierframe.import.report"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("F\ufffdljande kolumner har importerats fr\ufffdn leverant\ufffdrsfilen:<br>");
        sb.append("<ul>");
        if (this.iColumns.containsKey("Leverant\u00f6rs-id")) {
            sb.append("<li>").append("Leverant\u00f6rs-id").append("</li>");
        }
        if (this.iColumns.containsKey("Namn")) {
            sb.append("<li>").append("Namn").append("</li>");
        }
        if (this.iColumns.containsKey("Telefon1")) {
            sb.append("<li>").append("Telefon1").append("</li>");
        }
        if (this.iColumns.containsKey("Telefon2")) {
            sb.append("<li>").append("Telefon2").append("</li>");
        }
        if (this.iColumns.containsKey("Fax")) {
            sb.append("<li>").append("Fax").append("</li>");
        }
        if (this.iColumns.containsKey("Epost")) {
            sb.append("<li>").append("Epost").append("</li>");
        }
        if (this.iColumns.containsKey("Hemsida")) {
            sb.append("<li>").append("Hemsida").append("</li>");
        }
        if (this.iColumns.containsKey("Kontaktperson")) {
            sb.append("<li>").append("Kontaktperson").append("</li>");
        }
        if (this.iColumns.containsKey("Organisationsnummer")) {
            sb.append("<li>").append("Organisationsnummer").append("</li>");
        }
        if (this.iColumns.containsKey("V\u00e5rt kundnummer")) {
            sb.append("<li>").append("V\u00e5rt kundnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Bankgiro")) {
            sb.append("<li>").append("Bankgiro").append("</li>");
        }
        if (this.iColumns.containsKey("Plusgiro")) {
            sb.append("<li>").append("Plusgiro").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Namn")) {
            sb.append("<li>").append("Adress.Namn").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Adress1")) {
            sb.append("<li>").append("Adress.Adress1").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Adress2")) {
            sb.append("<li>").append("Adress.Adress2").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Postnummer")) {
            sb.append("<li>").append("Adress.Postnummer").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Postort")) {
            sb.append("<li>").append("Adress.Postort").append("</li>");
        }
        if (this.iColumns.containsKey("Adress.Land")) {
            sb.append("<li>").append("Adress.Land").append("</li>");
        }
        sb.append("</ul>");
        sb.append("F\ufffdljande leverant\ufffdrer kommer att importeras:<br>");
        sb.append("<ul>");
        for (SSSupplier iSupplier : iSuppliers) {
            sb.append("<li>");
            sb.append(iSupplier);
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("Forts\ufffdtt med importeringen ?");
        sb.append("</html>");
        iDialog.setText(sb.toString());
        iDialog.setSize(640, 480);
        iDialog.setLocationRelativeTo(SSMainFrame.getInstance());
        return iDialog.showDialog() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSSupplierImporter");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

