/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class SSVoucherExporter {
    public static final String NUMMER = "Nummer";
    public static final String BESKRIVNING = "Beskrivning";
    public static final String DATUM = "Datum";
    public static final String KONTO = "Konto";
    public static final String DEBET = "Debet";
    public static final String KREDIT = "Kredit";
    public static final String PROJEKT = "Projekt";
    public static final String RESULTATENHET = "Resultatenhet";
    private File iFile;
    private List<SSVoucher> iVouchers;

    public SSVoucherExporter(File iFile) {
        this.iFile = iFile;
        this.iVouchers = SSDB.getInstance().getVouchers();
    }

    public SSVoucherExporter(File iFile, List<SSVoucher> iVouchers) {
        this.iFile = iFile;
        this.iVouchers = iVouchers;
    }

    public void export() throws IOException, SSExportException {
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        try {
            WritableWorkbook iWorkbook = Workbook.createWorkbook(this.iFile, iSettings);
            WritableSheet iSheet = iWorkbook.createSheet("Verifikationer", 0);
            this.writeVouchers(new SSWritableExcelSheet(iSheet));
            iWorkbook.write();
            iWorkbook.close();
        }
        catch (WriteException e) {
            throw new SSExportException(e.getLocalizedMessage());
        }
    }

    private int getNumRows(List<SSVoucher> iVouchers) {
        int count = 0;
        for (SSVoucher iVoucher : iVouchers) {
            count = count + iVoucher.getRows().size() + 1;
        }
        return count;
    }

    private void writeVouchers(SSWritableExcelSheet pSheet) throws WriteException {
        List<SSWritableExcelRow> iRows = pSheet.getRows(this.getNumRows(this.iVouchers) + 4);
        WritableCellFormat iCellFormat = new WritableCellFormat();
        iCellFormat.setBackground(Colour.GRAY_25);
        iRows.get(0).setString(0, NUMMER, iCellFormat);
        iRows.get(0).setString(1, BESKRIVNING, iCellFormat);
        iRows.get(0).setString(2, DATUM, iCellFormat);
        iRows.get(0).setString(3, KONTO, iCellFormat);
        iRows.get(0).setString(4, DEBET, iCellFormat);
        iRows.get(0).setString(5, KREDIT, iCellFormat);
        iRows.get(0).setString(6, PROJEKT, iCellFormat);
        iRows.get(0).setString(7, RESULTATENHET, iCellFormat);
        iCellFormat = new WritableCellFormat();
        WritableFont iFont = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
        iCellFormat.setFont(iFont);
        int iRowIndex = 1;
        for (SSVoucher iVoucher : this.iVouchers) {
            SSWritableExcelRow iRow = iRows.get(++iRowIndex);
            iRow.setNumber(0, iVoucher.getNumber(), iCellFormat);
            iRow.setString(1, iVoucher.getDescription(), iCellFormat);
            iRow.setDate(2, iVoucher.getDate(), iCellFormat);
            for (SSVoucherRow iVoucherRow : iVoucher.getRows()) {
                if (iVoucherRow.isCrossed()) continue;
                iRow = iRows.get(++iRowIndex);
                iRow.setNumber(3, iVoucherRow.getAccountNr());
                iRow.setNumber(4, iVoucherRow.getDebet());
                iRow.setNumber(5, iVoucherRow.getCredit());
                iRow.setString(6, iVoucherRow.getProjectNr());
                iRow.setString(7, iVoucherRow.getResultUnitNr());
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSVoucherExporter");
        sb.append("{iFile=").append(this.iFile);
        sb.append(", iVouchers=").append(this.iVouchers);
        sb.append('}');
        return sb.toString();
    }
}

