/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.SSVoucherRow;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.data.system.SSPostLock;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.dialog.SSImportReportDialog;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelCell;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelRow;
import se.swedsoft.bookkeeping.importexport.excel.util.SSExcelSheet;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSVoucherImporter {
    private File iFile;
    private Map<String, Integer> iColumns;

    public SSVoucherImporter(File iFile) {
        this.iFile = iFile;
        this.iColumns = new HashMap<String, Integer>();
    }

    public void Import() throws IOException, SSImportException {
        String lockString = "voucher" + SSDB.getInstance().getCurrentCompany().getId() + SSDB.getInstance().getCurrentYear().getId();
        WorkbookSettings iSettings = new WorkbookSettings();
        iSettings.setLocale(new Locale("sv", "SE"));
        iSettings.setEncoding("windows-1252");
        iSettings.setExcelDisplayLanguage("SE");
        iSettings.setExcelRegionalSettings("SE");
        List<SSVoucher> iVouchers = null;
        try {
            Workbook iWorkbook = Workbook.getWorkbook(this.iFile, iSettings);
            if (iWorkbook.getNumberOfSheets() == 0) {
                throw new SSImportException(SSBundle.getBundle(), "voucherframe.import.nosheets");
            }
            Sheet iSheet = iWorkbook.getSheet(0);
            iVouchers = this.importVouchers(new SSExcelSheet(iSheet));
            iWorkbook.close();
        }
        catch (BiffException e) {
            throw new SSImportException(e.getLocalizedMessage());
        }
        if (iVouchers != null && this.showImportReport(iVouchers)) {
            for (SSVoucher iVoucher : iVouchers) {
                if (SSDB.getInstance().getVouchers().contains(iVoucher)) continue;
                SSDB.getInstance().addVoucher(iVoucher, false);
            }
        }
        SSPostLock.removeLock(lockString);
    }

    private void getColumnIndexes(SSExcelRow iColumns) {
        this.iColumns.clear();
        int iIndex = 0;
        for (SSExcelCell iColumn : iColumns.getCells()) {
            String iName = iColumn.getString();
            if (iName != null && iName.length() > 0) {
                if (iName.equalsIgnoreCase("Nummer")) {
                    this.iColumns.put("Nummer", iIndex);
                } else if (iName.equalsIgnoreCase("Beskrivning")) {
                    this.iColumns.put("Beskrivning", iIndex);
                } else if (iName.equalsIgnoreCase("Datum")) {
                    this.iColumns.put("Datum", iIndex);
                } else if (iName.equalsIgnoreCase("Konto")) {
                    this.iColumns.put("Konto", iIndex);
                } else if (iName.equalsIgnoreCase("Debet")) {
                    this.iColumns.put("Debet", iIndex);
                } else if (iName.equalsIgnoreCase("Kredit")) {
                    this.iColumns.put("Kredit", iIndex);
                } else if (iName.equalsIgnoreCase("Projekt")) {
                    this.iColumns.put("Projekt", iIndex);
                } else if (iName.equalsIgnoreCase("Resultatenhet")) {
                    this.iColumns.put("Resultatenhet", iIndex);
                } else {
                    throw new SSImportException("Ogiltigt kolumnnamn i importfilen: %s", iName);
                }
            }
            ++iIndex;
        }
    }

    private List<SSVoucher> importVouchers(SSExcelSheet pSheet) {
        List<SSExcelRow> iRows = pSheet.getRows();
        if (iRows.size() < 2) {
            throw new SSImportException(SSBundle.getBundle(), "voucherframe.import.norows");
        }
        this.getColumnIndexes(iRows.get(0));
        LinkedList<SSVoucher> iVouchers = new LinkedList<SSVoucher>();
        SSVoucher iVoucher = null;
        SSVoucherRow iVoucherRow = null;
        for (int row = 1; row < iRows.size(); ++row) {
            SSExcelRow iRow = iRows.get(row);
            if (iRow.empty()) continue;
            List<SSExcelCell> iCells = iRow.getCells();
            for (int col = 0; col < iCells.size(); ++col) {
                SSExcelCell iCell = iCells.get(col);
                String iValue = iCell.getString();
                if (iValue == null || iValue.trim().length() == 0) continue;
                if (this.iColumns.containsKey("Nummer") && this.iColumns.get("Nummer") == col) {
                    iVoucher = new SSVoucher();
                    iVoucher.setNumber(iCell.getInteger());
                    iVouchers.add(iVoucher);
                }
                if (iVoucher == null) continue;
                if (this.iColumns.containsKey("Beskrivning") && this.iColumns.get("Beskrivning") == col) {
                    iVoucher.setDescription(iValue);
                }
                if (this.iColumns.containsKey("Datum") && this.iColumns.get("Datum") == col) {
                    iVoucher.setDate(iCell.getDate());
                }
                if (this.iColumns.containsKey("Konto") && this.iColumns.get("Konto") == col) {
                    iVoucherRow = new SSVoucherRow();
                    iVoucherRow.setAccountNr(iCell.getInteger());
                    iVoucher.getRows().add(iVoucherRow);
                }
                if (iVoucherRow == null) continue;
                if (this.iColumns.containsKey("Debet") && this.iColumns.get("Debet") == col) {
                    iVoucherRow.setDebet(iCell.getBigDecimal());
                }
                if (this.iColumns.containsKey("Kredit") && this.iColumns.get("Kredit") == col) {
                    iVoucherRow.setCredit(iCell.getBigDecimal());
                }
                if (this.iColumns.containsKey("Projekt") && this.iColumns.get("Projekt") == col) {
                    iVoucherRow.setProjectNr(iCell.getString());
                }
                if (!this.iColumns.containsKey("Resultatenhet") || this.iColumns.get("Resultatenhet") != col) continue;
                iVoucherRow.setResultUnitNr(iCell.getString());
            }
        }
        return iVouchers;
    }

    private boolean showImportReport(List<SSVoucher> iVouchers) {
        SSImportReportDialog iDialog = new SSImportReportDialog(SSMainFrame.getInstance(), SSBundle.getBundle().getString("voucherframe.import.report"));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("F\u00f6ljande verifikationer kommer att importeras:<br>");
        sb.append("<ul>");
        for (SSVoucher iVoucher : iVouchers) {
            sb.append("<li>");
            sb.append(iVoucher);
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("Forts\u00e4tt med importeringen ?");
        sb.append("</html>");
        iDialog.setText(sb.toString());
        iDialog.setSize(640, 480);
        iDialog.setLocationRelativeTo(SSMainFrame.getInstance());
        return iDialog.showDialog() == 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.SSVoucherImporter");
        sb.append("{iColumns=").append(this.iColumns);
        sb.append(", iFile=").append(this.iFile);
        sb.append('}');
        return sb.toString();
    }
}

