/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel.util;

import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class SSWritableExcelCell {
    private int iRow;
    private int iColumn;
    private WritableSheet iSheet;

    public SSWritableExcelCell(WritableSheet pSheet, int pRow, int pColumn) {
        this.iSheet = pSheet;
        this.iRow = pRow;
        this.iColumn = pColumn;
    }

    public void setString(String pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Label(this.iColumn, this.iRow, pValue));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setInteger(Integer pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Number(this.iColumn, this.iRow, (double)pValue.intValue()));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setDouble(Double pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Number(this.iColumn, this.iRow, pValue));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public int getColumn() {
        return this.iColumn;
    }

    public int getRow() {
        return this.iRow;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelCell");
        sb.append("{iColumn=").append(this.iColumn);
        sb.append(", iRow=").append(this.iRow);
        sb.append(", iSheet=").append(this.iSheet);
        sb.append('}');
        return sb.toString();
    }
}

