/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.excel.util;

import java.util.LinkedList;
import java.util.List;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableSheet;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelRow;

public class SSWritableExcelSheet {
    private WritableSheet iSheet;

    public SSWritableExcelSheet(WritableSheet pSheet) {
        this.iSheet = pSheet;
    }

    public List<SSWritableExcelRow> getRows(int pCount) {
        LinkedList<SSWritableExcelRow> iList = new LinkedList<SSWritableExcelRow>();
        for (int iRow = 0; iRow < pCount; ++iRow) {
            iList.add(new SSWritableExcelRow(this.iSheet, iRow));
        }
        return iList;
    }

    public void setString(int iRow, int iColumn, String pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Label(iColumn, iRow, pValue));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setInteger(int iRow, int iColumn, Integer pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Number(iColumn, iRow, (double)pValue.intValue()));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public void setDouble(int iRow, int iColumn, Double pValue) throws WriteException {
        try {
            this.iSheet.addCell(new Number(iColumn, iRow, pValue));
        }
        catch (RowsExceededException e) {
            e.printStackTrace();
        }
    }

    public WritableSheet getSheet() {
        return this.iSheet;
    }

    public void setSheet(WritableSheet iSheet) {
        this.iSheet = iSheet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.excel.util.SSWritableExcelSheet");
        sb.append("{iSheet=").append(this.iSheet);
        sb.append('}');
        return sb.toString();
    }
}

