/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewCompany;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEFactory;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEFile;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEType;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class SSSIEExporter {
    private List<String> iLines = new LinkedList<String>();
    private SIEType iType;
    private String iComment;

    public SSSIEExporter(SIEType pType) {
        this.iType = pType;
        this.iComment = null;
    }

    public SSSIEExporter(SIEType pType, String pComment) {
        this.iType = pType;
        this.iComment = pComment;
    }

    public void exportSIE(File pFile) throws SSExportException {
        SSNewAccountingYear iYearData = SSDB.getInstance().getCurrentYear();
        if (iYearData == null) {
            throw new SSExportException(SSBundleString.getString("sieexport.noyear"));
        }
        SSNewCompany iCompany = SSDB.getInstance().getCurrentCompany();
        if (iCompany == null) {
            throw new SSExportException(SSBundleString.getString("sieexport.nocompany"));
        }
        SIEFactory iFactory = SIEFactory.getExportInstance(this.iType);
        for (SIELabel iLabel : iFactory.getLabels()) {
            SIEWriter iWriter;
            SIEEntry iEntry = iLabel.getEntry();
            if (iEntry == null || !iEntry.exportEntry(this, iWriter = new SIEWriter(), iYearData)) continue;
            if (iWriter.getLines().isEmpty()) {
                throw new RuntimeException("Entry reported data but no lines found: " + iEntry);
            }
            this.iLines.addAll(iWriter.getLines());
        }
        this.writeFile(pFile);
    }

    protected void readFile(File pFile) throws SSExportException {
        try {
            this.iLines = SIEFile.readFile(pFile);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
    }

    private void writeFile(File pFile) throws SSExportException {
        try {
            SIEFile.writeFile(pFile, this.iLines);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new SSExportException(ex.getMessage());
        }
    }

    public void setType(SIEType pType) {
        this.iType = pType;
    }

    public SIEType getType() {
        return this.iType;
    }

    public String getComment() {
        return this.iComment;
    }

    public List<String> getLines() {
        return this.iLines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter");
        sb.append("{iComment='").append(this.iComment).append('\'');
        sb.append(", iLines=").append(this.iLines);
        sb.append(", iType=").append((Object)this.iType);
        sb.append('}');
        return sb.toString();
    }
}

