/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.math.BigDecimal;
import java.util.Map;
import se.swedsoft.bookkeeping.calc.SSBalanceCalculator;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryInBalance
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iCurrentYearData) throws SSImportException {
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.FLOAT)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        int iYear = iReader.nextInteger();
        int iAccountNumber = iReader.nextInteger();
        if (iYear == 0 && iCurrentYearData != null) {
            Map<SSAccount, BigDecimal> iInbalance = iCurrentYearData.getInBalance();
            SSAccount iAccount = iCurrentYearData.getAccountPlan().getAccount(iAccountNumber);
            iInbalance.put(iAccount, iReader.nextBigDecimal());
        }
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        BigDecimal iValue;
        Map<SSAccount, BigDecimal> iInbalance;
        SSNewAccountingYear iPreviousYearData = SSDB.getInstance().getPreviousYear();
        boolean iHasData = false;
        if (iPreviousYearData != null) {
            iInbalance = SSBalanceCalculator.getInBalance(iPreviousYearData);
            for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iInbalance.entrySet()) {
                iValue = ssAccountBigDecimalEntry.getValue();
                if (iValue == null) continue;
                iWriter.append(SIELabel.SIE_IB);
                iWriter.append(-1);
                iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                iWriter.append(iValue);
                iWriter.newLine();
                iHasData = true;
            }
        }
        if (iCurrentYearData != null) {
            iInbalance = SSBalanceCalculator.getInBalance(iCurrentYearData);
            for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iInbalance.entrySet()) {
                iValue = ssAccountBigDecimalEntry.getValue();
                if (iValue == null) continue;
                iWriter.append(SIELabel.SIE_IB);
                iWriter.append(0);
                iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                iWriter.append(iValue);
                iWriter.newLine();
                iHasData = true;
            }
        }
        return iHasData;
    }
}

