/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.util.List;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSNewProject;
import se.swedsoft.bookkeeping.data.SSNewResultUnit;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.SSMainFrame;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.gui.util.dialogs.SSErrorDialog;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.types.SIEDimension;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryObjekt
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.STRING) && !iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.STRING)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        int iNumber = iReader.nextInteger();
        SIEDimension iDimension = iImporter.getDimension(iNumber);
        if (iDimension == null) {
            System.out.println("No dimension:" + iNumber);
            return false;
        }
        String iNum = iReader.next();
        if (iNum == null) {
            new SSErrorDialog(SSMainFrame.getInstance(), "sieimport.stringnumber");
            return true;
        }
        if (iDimension.getNumber() == 1) {
            SSNewResultUnit iResultUnit = new SSNewResultUnit();
            iResultUnit.setNumber(iNum);
            iResultUnit.setName(iReader.nextString());
            SSDB.getInstance().addResultUnit(iResultUnit);
        }
        if (iDimension.getNumber() == 6) {
            SSNewProject iProject = new SSNewProject();
            iProject.setNumber(iNum);
            iProject.setName(iReader.nextString());
            SSDB.getInstance().addProject(iProject);
        }
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        List<SSNewResultUnit> iResultUnits = SSDB.getInstance().getResultUnits();
        List<SSNewProject> iProjects = SSDB.getInstance().getProjects();
        for (SSNewResultUnit iResultUnit : iResultUnits) {
            iWriter.append(SIELabel.SIE_OBJEKT);
            iWriter.append(1);
            iWriter.append(iResultUnit.getNumber());
            iWriter.append(iResultUnit.getName());
            iWriter.newLine();
        }
        for (SSNewProject iProject : iProjects) {
            iWriter.append(SIELabel.SIE_OBJEKT);
            iWriter.append(6);
            iWriter.append(iProject.getNumber());
            iWriter.append(iProject.getName());
            iWriter.newLine();
        }
        return !iResultUnits.isEmpty() || !iProjects.isEmpty();
    }
}

