/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.math.BigDecimal;
import java.util.Map;
import se.swedsoft.bookkeeping.data.SSAccount;
import se.swedsoft.bookkeeping.data.SSBudget;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryPeriodBudget
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iCurrentYearData) throws SSImportException {
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.INT, SIEReader.SIEDataType.ARRAY, SIEReader.SIEDataType.FLOAT)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        int iYear = iReader.nextInteger();
        SSMonth iMonth = iReader.nextMonth();
        int iAccountNumber = iReader.nextInteger();
        iReader.nextArray();
        BigDecimal iSaldo = iReader.nextBigDecimal();
        if (iYear == 0 && iCurrentYearData != null) {
            SSBudget iBudget = iCurrentYearData.getBudget();
            SSAccount iAccount = iCurrentYearData.getAccountPlan().getAccount(iAccountNumber);
            iMonth = iBudget.getMonth(iMonth);
            if (iSaldo == null) {
                iSaldo = new BigDecimal(0);
            }
            iBudget.setSaldoForAccountAndMonth(iAccount, iMonth, iSaldo.negate());
        }
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        BigDecimal iSaldo;
        Map<SSAccount, BigDecimal> iAccounts;
        Map<SSMonth, Map<SSAccount, BigDecimal>> iBudgetData;
        SSBudget iBudget;
        SSNewAccountingYear iPreviousYearData = SSDB.getInstance().getPreviousYear();
        boolean iHasData = false;
        if (iPreviousYearData != null) {
            iBudget = iPreviousYearData.getBudget();
            iBudgetData = iBudget.getBudget();
            for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iBudgetData.entrySet()) {
                iAccounts = ssMonthMapEntry.getValue();
                for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iAccounts.entrySet()) {
                    iSaldo = ssAccountBigDecimalEntry.getValue();
                    if (iSaldo == null) continue;
                    iWriter.append(SIELabel.SIE_PBUDGET);
                    iWriter.append(-1);
                    iWriter.append(ssMonthMapEntry.getKey());
                    iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                    iWriter.append("{}");
                    iWriter.append(iSaldo.negate());
                    iWriter.newLine();
                    iHasData = true;
                }
            }
        }
        if (iCurrentYearData != null) {
            iBudget = iCurrentYearData.getBudget();
            iBudgetData = iBudget.getBudget();
            for (Map.Entry<SSMonth, Map<SSAccount, BigDecimal>> ssMonthMapEntry : iBudgetData.entrySet()) {
                iAccounts = ssMonthMapEntry.getValue();
                for (Map.Entry<SSAccount, BigDecimal> ssAccountBigDecimalEntry : iAccounts.entrySet()) {
                    iSaldo = ssAccountBigDecimalEntry.getValue();
                    if (iSaldo == null) continue;
                    iWriter.append(SIELabel.SIE_PBUDGET);
                    iWriter.append(0);
                    iWriter.append(ssMonthMapEntry.getKey());
                    iWriter.append(ssAccountBigDecimalEntry.getKey().getNumber());
                    iWriter.append("{}");
                    iWriter.append(iSaldo.negate());
                    iWriter.newLine();
                    iHasData = true;
                }
            }
        }
        return iHasData;
    }
}

