/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.fields;

import java.util.Date;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSVoucherMath;
import se.swedsoft.bookkeeping.data.SSNewAccountingYear;
import se.swedsoft.bookkeeping.data.SSVoucher;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundleString;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEExporter;
import se.swedsoft.bookkeeping.importexport.sie.SSSIEImporter;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntry;
import se.swedsoft.bookkeeping.importexport.sie.fields.SIEEntryTransaktion;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEReader;
import se.swedsoft.bookkeeping.importexport.sie.util.SIEWriter;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SIEEntryVerifikation
implements SIEEntry {
    @Override
    public boolean importEntry(SSSIEImporter iImporter, SIEReader iReader, SSNewAccountingYear iYearData) throws SSImportException {
        String iDescription;
        if (!iReader.hasFields(SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.STRING, SIEReader.SIEDataType.STRING)) {
            throw new SSImportException(SSBundleString.getString("sieimport.fielderror", iReader.peekLine()));
        }
        SSVoucher iVoucher = new SSVoucher();
        String iSerie = iReader.nextString();
        Integer iNumber = iReader.nextInteger();
        Date iDate = iReader.hasNextDate() ? iReader.nextDate() : new Date();
        String string = iDescription = iReader.hasNextString() ? iReader.nextString() : null;
        if (!iSerie.equals("A") && iSerie.length() > 0) {
            iNumber = iSerie.charAt(0) - 65 < 0 ? Integer.valueOf(iNumber + 10000 * iSerie.charAt(0) + 2000000) : Integer.valueOf(iNumber + 10000 * (iSerie.charAt(0) - 65) + 1000000);
        }
        boolean iHasNumber = false;
        if (iNumber != null && !SSVoucherMath.hasVoucher(iNumber)) {
            iVoucher.setNumber(iNumber);
            iHasNumber = true;
        }
        iVoucher.setDate(iDate);
        iVoucher.setDescription(iDescription);
        while (iReader.hasNextLine()) {
            iReader.nextLine();
            String iLabel = iReader.next();
            SIEEntry iEntry = iImporter.getFactory().get(iLabel);
            if (iEntry == null || !(iEntry instanceof SIEEntryTransaktion)) {
                throw new SSImportException("Row of voucher is not #TRANS");
            }
            ((SIEEntryTransaktion)iEntry).importEntry(iVoucher, iImporter, iReader, iYearData);
        }
        SSDB.getInstance().addVoucher(iVoucher, iHasNumber);
        return true;
    }

    @Override
    public boolean exportEntry(SSSIEExporter iExporter, SIEWriter iWriter, SSNewAccountingYear iCurrentYearData) throws SSExportException {
        List<SSVoucher> iVouchers = SSDB.getInstance().getVouchers();
        SIEEntryTransaktion iEntry = new SIEEntryTransaktion();
        for (SSVoucher iVoucher : iVouchers) {
            iWriter.append(SIELabel.SIE_VER);
            iWriter.append("A");
            iWriter.append(iVoucher.getNumber());
            iWriter.append(iVoucher.getDate());
            iWriter.append(iVoucher.getDescription());
            iWriter.newLine();
            iWriter.newLine("{");
            iEntry.exportEntry(iVoucher, iExporter, iWriter);
            iWriter.newLine("}");
        }
        return !iVouchers.isEmpty();
    }
}

