/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.sie.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.data.SSMonth;
import se.swedsoft.bookkeeping.importexport.sie.util.SIELabel;

public class SIEWriter {
    private static DateFormat iFormat = new SimpleDateFormat("yyyyMMdd");
    private StringBuilder iStringBuilder = new StringBuilder();
    private List<String> iLines = new LinkedList<String>();

    public void newLine() {
        this.iLines.add(this.iStringBuilder.toString());
        this.iStringBuilder = new StringBuilder();
    }

    public void newLine(String iLine) {
        this.iLines.add(iLine);
        this.iStringBuilder = new StringBuilder();
    }

    public void append(String pValue) {
        if (pValue != null && pValue.contains(" ")) {
            this.iStringBuilder.append('\"');
            this.iStringBuilder.append(pValue);
            this.iStringBuilder.append("\" ");
        } else {
            this.iStringBuilder.append(pValue);
            this.iStringBuilder.append(' ');
        }
    }

    public void append(Object pValue) {
        this.iStringBuilder.append(pValue);
        this.iStringBuilder.append(' ');
    }

    public void append(Object ... pValues) {
        this.iStringBuilder.append('{');
        for (Object iObject : pValues) {
            if (iObject == null) continue;
            this.append(iObject);
        }
        this.iStringBuilder.append("} ");
    }

    public void append(List<Object> pValues) {
        this.iStringBuilder.append('{');
        for (Object iObject : pValues) {
            if (iObject == null) continue;
            this.append(iObject);
        }
        this.iStringBuilder.append("} ");
    }

    public void append(SSMonth pValue) {
        SimpleDateFormat iFormat = new SimpleDateFormat("yyyyMM");
        String iValue = pValue != null ? iFormat.format(pValue.getDate()) : "000000";
        this.iStringBuilder.append(iValue);
        this.iStringBuilder.append(' ');
    }

    public void append(SIELabel pValue) {
        this.iStringBuilder.append(pValue.getName());
        this.iStringBuilder.append(' ');
    }

    public void append(Date pValue) {
        String iValue = pValue != null ? iFormat.format(pValue).replace("-", "") : "00000000";
        this.iStringBuilder.append(iValue);
        this.iStringBuilder.append(' ');
    }

    public void append(Integer pValue) {
        this.iStringBuilder.append(pValue);
        this.iStringBuilder.append(' ');
    }

    public void append(Float pValue) {
        if (pValue != null) {
            this.append(pValue.doubleValue());
        } else {
            this.append(0);
        }
    }

    public void append(Double pValue) {
        NumberFormat iFormat = NumberFormat.getNumberInstance();
        iFormat.setMinimumFractionDigits(2);
        iFormat.setMaximumFractionDigits(2);
        iFormat.setGroupingUsed(false);
        String iValue = iFormat.format(pValue);
        iValue = iValue.replace(",", ".");
        this.iStringBuilder.append(iValue);
        this.iStringBuilder.append(' ');
    }

    public void append(boolean pValue) {
        this.iStringBuilder.append(pValue);
        this.iStringBuilder.append(' ');
    }

    public void append(BigInteger pValue) {
        this.iStringBuilder.append(pValue);
        this.iStringBuilder.append(' ');
    }

    public void append(BigDecimal pValue) {
        this.append(pValue.doubleValue());
    }

    public String getLine() {
        return this.iStringBuilder.toString().trim();
    }

    public List<String> getLines() {
        return this.iLines;
    }

    public String toString() {
        return this.iStringBuilder.toString().trim();
    }
}

