/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.PaymentMethod;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK11;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK12;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK13;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK14;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK26;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK27;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK29;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK40;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK54;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;
import se.swedsoft.bookkeeping.importexport.util.SSExportException;

public class SSSupplierPaymentExporter {
    private SSSupplierPaymentExporter() {
    }

    public static void Export(File iFile, List<SupplierPayment> iPayments) throws SSExportException {
        List<LBinPost> iLines = SSSupplierPaymentExporter.getPosts(iPayments);
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(iFile), StandardCharsets.ISO_8859_1);
            BufferedWriter iWriter = new BufferedWriter(osw);
            for (LBinPost iPost : iLines) {
                if (iPost.isEmpty()) continue;
                LBinLine iLine = new LBinLine(80);
                iPost.write(iLine);
                iWriter.write(iLine.toString());
                iWriter.write(13);
                iWriter.write(10);
            }
            iWriter.flush();
            iWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<LBinPost> getPosts(List<SupplierPayment> iPayments) {
        LinkedList<LBinPost> iPosts = new LinkedList<LBinPost>();
        iPosts.addAll(SSSupplierPaymentExporter.getAvsnitt(iPayments, "SEK"));
        iPosts.addAll(SSSupplierPaymentExporter.getAvsnitt(iPayments, "EUR"));
        return iPosts;
    }

    public static List<LBinPost> getAvsnitt(List<SupplierPayment> iPayments, String iCurrency) {
        List<SupplierPayment> iFiltered = SupplierPayment.getPayments(iPayments, iCurrency);
        LinkedList<LBinPost> iPosts = new LinkedList<LBinPost>();
        if (iPayments.isEmpty()) {
            return iPosts;
        }
        iPosts.add(new LBinPostTK11(iCurrency));
        iPosts.add(new LBinPostTK12());
        iPosts.add(new LBinPostTK13());
        BigDecimal iSum = new BigDecimal(0);
        for (SupplierPayment iPayment : iFiltered) {
            PaymentMethod iPaymentMethod = iPayment.getPaymentMethod();
            if (iPaymentMethod == PaymentMethod.BANKGIRO) {
                iPosts.add(new LBinPostTK14(iPayment, iPayment.getBankGiro()));
            }
            if (iPaymentMethod == PaymentMethod.PLUSGIRO) {
                if (!iCurrency.equals("SEK")) {
                    throw new SSExportException(SSBundle.getBundle(), "supplierpaymentframe.error.plusgirocurrency");
                }
                iPosts.add(new LBinPostTK54(iPayment));
            }
            if (iPaymentMethod == PaymentMethod.CASH) {
                iPosts.add(new LBinPostTK14(iPayment, iPayment.getOutpaymentNumber() + " "));
                iPosts.add(new LBinPostTK26(iPayment));
                iPosts.add(new LBinPostTK27(iPayment));
            }
            if (iPaymentMethod == PaymentMethod.KONTO) {
                iPosts.add(new LBinPostTK14(iPayment, iPayment.getBankGiro()));
                iPosts.add(new LBinPostTK40(iPayment));
            }
            iSum = iSum.add(iPayment.getValue());
        }
        iPosts.add(new LBinPostTK29(iFiltered.size(), iSum));
        return iPosts;
    }
}

