/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSOutpayment;
import se.swedsoft.bookkeeping.data.SSOutpaymentRow;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.gui.util.SSBundle;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK11;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK12;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK13;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK14;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK26;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK27;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK29;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK40;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK54;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;
import se.swedsoft.bookkeeping.importexport.util.SSImportException;

public class SSSupplierPaymentImporter {
    private SSSupplierPaymentImporter() {
    }

    /*
     * WARNING - void declaration
     */
    public static List<SSOutpayment> Import(File iFile) throws SSImportException {
        LinkedList<Object> iLines = new LinkedList<Object>();
        try {
            Object iLine;
            BufferedReader iReader = new BufferedReader(new FileReader(iFile));
            while ((iLine = iReader.readLine()) != null) {
                iLines.add(iLine);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedList<LBinPost> iPosts = new LinkedList<LBinPost>();
        for (String string : iLines) {
            LBinLine iReader = new LBinLine(string);
            String iPostTyp = iReader.readString(1, 2);
            LBinPost iPost = SSSupplierPaymentImporter.getPost(iPostTyp);
            if (iPost != null) {
                iPost.read(iReader);
                iPosts.add(iPost);
                continue;
            }
            System.out.println("Oidentifierad posttyp: " + iPostTyp);
        }
        LinkedList<SSOutpayment> iOutpayments = new LinkedList<SSOutpayment>();
        Object var4_6 = null;
        boolean paymentRead = false;
        for (LBinPost iPost : iPosts) {
            SSOutpaymentRow iRow;
            SSSupplierInvoice iSupplierInvoice;
            Integer iInvoiceNr;
            String iReference;
            void var4_7;
            if (iPost instanceof LBinPostTK11) {
                LBinPostTK11 iPostTK11 = (LBinPostTK11)iPost;
                Date iPaymentDate = iPostTK11.getPaymentDate();
                DateFormat iFormat = DateFormat.getDateInstance(3);
                SSOutpayment sSOutpayment = new SSOutpayment();
                sSOutpayment.setText("Leverant\u00f6rsbetalning");
                sSOutpayment.setDate(iPaymentDate);
                sSOutpayment.setText("Leverant\u00f6rsbetalning " + iFormat.format(iPaymentDate));
                iOutpayments.add(sSOutpayment);
            }
            if (var4_7 == null) continue;
            if (iPost instanceof LBinPostTK14) {
                LBinPostTK14 iPostTK14 = (LBinPostTK14)iPost;
                iReference = iPostTK14.getReference().trim();
                iInvoiceNr = iPostTK14.getInvoiceNr();
                iSupplierInvoice = SSSupplierInvoiceMath.getSupplierInvoiceByNumber(SSDB.getInstance().getSupplierInvoices(), iInvoiceNr);
                if (iSupplierInvoice == null) {
                    iSupplierInvoice = SSSupplierInvoiceMath.getSupplierInvoiceByReference(SSDB.getInstance().getSupplierInvoices(), iReference);
                }
                if (iSupplierInvoice != null) {
                    iRow = new SSOutpaymentRow();
                    iRow.setSupplierInvoice(iSupplierInvoice);
                    iRow.setValue(iPostTK14.getValue());
                    var4_7.getRows().add(iRow);
                    paymentRead = true;
                } else {
                    throw new SSImportException(SSBundle.getBundle(), "supplierpaymentimport.error.invalidreference", iReference);
                }
            }
            if (!(iPost instanceof LBinPostTK54)) continue;
            LBinPostTK54 iPostTK54 = (LBinPostTK54)iPost;
            iReference = iPostTK54.getReference().trim();
            iInvoiceNr = iPostTK54.getInvoiceNr();
            iSupplierInvoice = SSSupplierInvoiceMath.getSupplierInvoiceByNumber(SSDB.getInstance().getSupplierInvoices(), iInvoiceNr);
            if (iSupplierInvoice == null) {
                iSupplierInvoice = SSSupplierInvoiceMath.getSupplierInvoiceByReference(SSDB.getInstance().getSupplierInvoices(), iReference);
            }
            if (iSupplierInvoice != null) {
                iRow = new SSOutpaymentRow();
                iRow.setSupplierInvoice(iSupplierInvoice);
                iRow.setValue(iPostTK54.getValue());
                var4_7.getRows().add(iRow);
                paymentRead = true;
                continue;
            }
            throw new SSImportException(SSBundle.getBundle(), "supplierpaymentimport.error.invalidreference", iReference);
        }
        if (!paymentRead) {
            throw new SSImportException(SSBundle.getBundle(), "supplierpaymentimport.error.nopaymentread");
        }
        return iOutpayments;
    }

    private static LBinPost getPost(String iPostTyp) {
        if (iPostTyp.equals("11")) {
            return new LBinPostTK11();
        }
        if (iPostTyp.equals("12")) {
            return new LBinPostTK12();
        }
        if (iPostTyp.equals("13")) {
            return new LBinPostTK13();
        }
        if (iPostTyp.equals("14")) {
            return new LBinPostTK14();
        }
        if (iPostTyp.equals("26")) {
            return new LBinPostTK26();
        }
        if (iPostTyp.equals("27")) {
            return new LBinPostTK27();
        }
        if (iPostTyp.equals("29")) {
            return new LBinPostTK29();
        }
        if (iPostTyp.equals("40")) {
            return new LBinPostTK40();
        }
        if (iPostTyp.equals("54")) {
            return new LBinPostTK54();
        }
        return null;
    }
}

