/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import se.swedsoft.bookkeeping.calc.math.SSSupplierInvoiceMath;
import se.swedsoft.bookkeeping.data.SSAddress;
import se.swedsoft.bookkeeping.data.SSSupplier;
import se.swedsoft.bookkeeping.data.SSSupplierInvoice;
import se.swedsoft.bookkeeping.data.system.SSDB;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.PaymentMethod;

public class SupplierPayment {
    private SSSupplierInvoice iInvoice;
    private BigDecimal iValue;
    private String iAccount;
    private PaymentMethod iPaymentMethod;
    private Date iDate;
    private String iCurrency;

    public SupplierPayment(SSSupplierInvoice iInvoice) {
        this.iInvoice = iInvoice;
        this.iPaymentMethod = PaymentMethod.BANKGIRO;
        this.iValue = SSSupplierInvoiceMath.getSaldo(iInvoice.getNumber());
        this.iAccount = this.getBankGiro();
        this.iDate = iInvoice.getDueDate() == null ? new Date() : iInvoice.getDueDate();
        this.iCurrency = iInvoice.getCurrency() == null ? "SEK" : iInvoice.getCurrency().getName();
    }

    public SSSupplierInvoice getSupplierInvoice() {
        return this.iInvoice;
    }

    public void setSupplierInvoice(SSSupplierInvoice iInvoice) {
        this.iInvoice = iInvoice;
    }

    public BigDecimal getValue() {
        if (this.iValue == null) {
            this.iValue = new BigDecimal(0);
        }
        return this.iValue;
    }

    public void setValue(BigDecimal iValue) {
        this.iValue = iValue;
    }

    public String getAccount() {
        return this.iAccount;
    }

    public void setAccount(String iAccount) {
        this.iAccount = iAccount;
    }

    public PaymentMethod getPaymentMethod() {
        return this.iPaymentMethod;
    }

    public void setPaymentMethod(PaymentMethod iMethod) {
        this.iPaymentMethod = iMethod;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public Integer getNumber() {
        return this.iInvoice.getNumber();
    }

    public String getReference() {
        return this.iInvoice.getReferencenumber();
    }

    public String getCurrency() {
        return this.iCurrency;
    }

    public SSSupplier getSupplier() {
        return this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
    }

    public String getBankGiro() {
        SSSupplier iSupplier = this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
        return iSupplier == null ? null : iSupplier.getBankgiro();
    }

    public String getPlusGiro() {
        SSSupplier iSupplier = this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
        return iSupplier == null ? null : iSupplier.getPlusgiro();
    }

    public String getKonto() {
        SSSupplier iSupplier = this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
        return iSupplier == null ? null : iSupplier.getBankgiro();
    }

    public Integer getOutpaymentNumber() {
        SSSupplier iSupplier = this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
        return iSupplier == null ? null : iSupplier.getOutpaymentNumber();
    }

    public SSAddress getAddress() {
        SSSupplier iSupplier = this.iInvoice.getSupplier(SSDB.getInstance().getSuppliers());
        return iSupplier == null ? null : iSupplier.getAddress();
    }

    public static List<SupplierPayment> getPayments(List<SupplierPayment> iPayments, String iCurrency) {
        LinkedList<SupplierPayment> iFiltered = new LinkedList<SupplierPayment>();
        for (SupplierPayment iPayment : iPayments) {
            if (!iCurrency.equals(iPayment.iCurrency)) continue;
            iFiltered.add(iPayment);
        }
        return iFiltered;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SupplierPayment) {
            SupplierPayment iPayment = (SupplierPayment)obj;
            return iPayment.iInvoice.equals(this.iInvoice);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPayment");
        sb.append("{iAccount='").append(this.iAccount).append('\'');
        sb.append(", iCurrency='").append(this.iCurrency).append('\'');
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iInvoice=").append(this.iInvoice);
        sb.append(", iPaymentMethod=").append((Object)this.iPaymentMethod);
        sb.append(", iValue=").append(this.iValue);
        sb.append('}');
        return sb.toString();
    }
}

