/*
 * Decompiled with CFR 0.152.
 */
package se.swedsoft.bookkeeping.importexport.supplierpayments.poster;

import java.util.Date;
import se.swedsoft.bookkeeping.importexport.supplierpayments.data.SupplierPaymentConfig;
import se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPost;
import se.swedsoft.bookkeeping.importexport.supplierpayments.util.LBinLine;

public class LBinPostTK11
extends LBinPost {
    private String iCurrency;
    private String iBankGiroNr;
    private Date iDate;
    private Date iPaymentDate;
    private String iText;

    public LBinPostTK11() {
    }

    public LBinPostTK11(String iCurrency) {
        this.iBankGiroNr = SupplierPaymentConfig.getOurBankGiroAccount().replaceAll("-", "");
        this.iDate = new Date();
        this.iCurrency = iCurrency;
        this.iText = "LEVERANT\u00d6RSBETALNINGAR";
    }

    @Override
    public void write(LBinLine iLine) {
        iLine.append("11");
        iLine.append(this.iBankGiroNr, 10, '0');
        iLine.append(this.iDate, 6, "yyMMdd");
        iLine.append(this.iText, 22);
        iLine.append("", 6);
        iLine.append("", 13);
        iLine.append(this.iCurrency, 3);
        iLine.append("", 18);
    }

    @Override
    public void read(LBinLine iLine) {
        this.iBankGiroNr = iLine.readString(3, 12);
        this.iDate = iLine.readDate(13, 18, "yyMMdd");
        this.iText = iLine.readString(19, 40);
        this.iPaymentDate = iLine.readDate(41, 46, "yyMMdd");
        this.iCurrency = iLine.readString(60, 62);
    }

    public String getiCurrency() {
        return this.iCurrency;
    }

    public void setCurrency(String iCurrency) {
        this.iCurrency = iCurrency;
    }

    public String getBankGiroNr() {
        return this.iBankGiroNr;
    }

    public void setBankGiroNr(String iBankGiroNr) {
        this.iBankGiroNr = iBankGiroNr;
    }

    public Date getDate() {
        return this.iDate;
    }

    public void setDate(Date iDate) {
        this.iDate = iDate;
    }

    public Date getPaymentDate() {
        return this.iPaymentDate;
    }

    public void setPaymentDate(Date iPaymentDate) {
        this.iPaymentDate = iPaymentDate;
    }

    public String getText() {
        return this.iText;
    }

    public void setText(String iText) {
        this.iText = iText;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("se.swedsoft.bookkeeping.importexport.supplierpayments.poster.LBinPostTK11");
        sb.append("{iBankGiroNr='").append(this.iBankGiroNr).append('\'');
        sb.append(", iCurrency='").append(this.iCurrency).append('\'');
        sb.append(", iDate=").append(this.iDate);
        sb.append(", iPaymentDate=").append(this.iPaymentDate);
        sb.append(", iText='").append(this.iText).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

